package com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables;

import com.xforceplus.ultraman.metadata.sync.grpc.store.TableLike;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *     int64 id = 1;
 *     string code = 2;
 *     string name = 3;
 *     string branch = 4;
 *     string version = 5;
 */
public class AppTable implements TableLike {

    public static final String TABLE_NAME = "app";

    public static final String APP_ID = "appId";

    public static final String APP_CODE = "appCode";

    public static final String APP_NAME = "appName";

    public static final String APP_BRANCH = "appBranch";

    public static final String APP_VERSION = "appVersion";

    private List<Map<String, ?>> store = new ArrayList<>();

    public static final String[] columns = new String[]{APP_ID, APP_CODE, APP_NAME, APP_BRANCH, APP_VERSION};

    @Override
    public String name() {
        return TABLE_NAME;
    }

    @Override
    public String[] columns() {
        return columns;
    }

    @Override
    public List<Map<String, ?>> getStore() {
        return store;
    }
}
