/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.transfer.listener;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.AppNode;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.sync.transfer.utils.DomainConverter;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.transfer.common.event.MetadataDeployEvent;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

public class SdkMetadataListener {
    private static final Logger log = LoggerFactory.getLogger(SdkMetadataListener.class);
    @Autowired
    private MetadataEngine engine;
    @Autowired
    private GlobalInited globalInited;
    @Autowired
    private EventEngine eventEngine;

    @Async
    @EventListener(value={SDKMetadataEvent.class})
    public void onApplicationEvent(MetadataDeployEvent event) {
        if (event instanceof SDKMetadataEvent) {
            AppNode appNode = DomainConverter.toAppNode((SDKMetadataEvent)event);
            this.engine.save(appNode);
            this.globalInited.moduleSaved();
            this.eventEngine.trigger(UltramanLifecycle.METADATA_REFRESHED, (Object)appNode);
        }
    }
}

