package com.xforceplus.ultraman.metadata.sync.transfer.listener;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.AppNode;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.sync.transfer.utils.DomainConverter;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.transfer.common.event.MetadataDeployEvent;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;


/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/23 18:56
 * Description:
 * History:
 */
@Slf4j
public class SdkMetadataListener {

    @Autowired
    private MetadataEngine engine;

    @Autowired
    private GlobalInited globalInited;

    @Autowired
    private EventEngine eventEngine;

    @Async
    @EventListener({SDKMetadataEvent.class})
    public void onApplicationEvent(MetadataDeployEvent event) {
        if (event instanceof SDKMetadataEvent) {
            AppNode appNode = DomainConverter.toAppNode((SDKMetadataEvent) event);
            engine.save(appNode);
            globalInited.moduleSaved();
            eventEngine.trigger(UltramanLifecycle.METADATA_REFRESHED, appNode);
        }
    }
}