/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.transfer.service.impl;

import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.dsl.utils.MatcherHelper;
import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.vo.dto.DictItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ResponseList;
import com.xforceplus.ultraman.metadata.service.DictService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;

public class DictServiceImpl
implements DictService {
    private final ContextService contextService;
    private MetadataEngine metadataEngine;

    public DictServiceImpl(ContextService contextService, MetadataEngine metadataEngine) {
        this.metadataEngine = metadataEngine;
        this.contextService = contextService;
    }

    public List<DictItem> findDictItems(String dictId, String enumCode, String tenantCode) {
        ResponseList list = new ResponseList();
        this.metadataEngine.raw(g -> {
            Map next;
            GraphTraversal traversal;
            GraphTraversal has = g.traversal().V(new Object[0]).has("nodeLabel", (Object)"Dict");
            if (dictId != null) {
                has = has.has("_id", (Object)dictId);
            }
            if ((traversal = has.has("profile", P.within((Object[])new String[]{null, tenantCode})).as("a", new String[0]).outE(new String[]{MetadataRelationType.HAS_ITEM.name()}).inV().as("b", new String[0]).select("a", "b", new String[0]).by((Traversal)__.valueMap((String[])new String[0])).group().by("a")).hasNext() && (next = (Map)traversal.next()) != null) {
                next.entrySet().stream().flatMap(entry -> {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    Map keyMap = (Map)key;
                    List valueList = (List)value;
                    return this.toDictItems(keyMap, valueList).stream();
                }).filter(item -> {
                    if (enumCode != null) {
                        return item.getValue().equals(enumCode);
                    }
                    return true;
                }).forEach(item -> list.add(item));
            }
            return null;
        });
        return list;
    }

    private String getFromMap(Map<String, Object> main, String key) {
        return Optional.ofNullable(main.get(key)).map(x -> (List)x).filter(x -> !x.isEmpty()).map(x -> x.get(0)).map(Object::toString).orElse(null);
    }

    private List<DictItem> toDictItems(Map<String, Object> main, List<Map<String, Object>> itemMap) {
        String id = this.getFromMap(main, "id");
        String code = this.getFromMap(main, "code");
        String name = this.getFromMap(main, "name");
        return itemMap.stream().map(x -> {
            DictItem item = new DictItem();
            item.setDictName(name);
            item.setDictId(id);
            item.setDictCode(code);
            Object b = x.get("b");
            if (b != null) {
                Map detailMap = (Map)b;
                String detailCode = this.getFromMap(detailMap, "code");
                String detailName = this.getFromMap(detailMap, "name");
                String detailIcon = this.getFromMap(detailMap, "icon");
                item.setValue(detailCode);
                item.setText(detailName);
                item.setIcon(detailIcon);
            }
            return item;
        }).collect(Collectors.toList());
    }

    public List<DictItem> findDictItemsByCode(String code, String enumCode, String tenantCode) {
        ResponseList list = new ResponseList();
        this.metadataEngine.raw(g -> {
            Map next;
            GraphTraversal traversal;
            GraphTraversal has = g.traversal().V(new Object[0]).has("nodeLabel", (Object)"Dict");
            if (code != null) {
                has = has.has("code", (P)MatcherHelper.caseInsensitiveEq((String)code));
            }
            if ((traversal = has.has("profile", P.within((Object[])new String[]{null, tenantCode})).as("a", new String[0]).outE(new String[]{MetadataRelationType.HAS_ITEM.name()}).inV().as("b", new String[0]).select("a", "b", new String[0]).by((Traversal)__.valueMap((String[])new String[0])).group().by("a")).hasNext() && (next = (Map)traversal.next()) != null) {
                next.entrySet().stream().flatMap(entry -> {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    Map keyMap = (Map)key;
                    List valueList = (List)value;
                    return this.toDictItems(keyMap, valueList).stream();
                }).filter(item -> {
                    if (enumCode != null) {
                        return item.getValue().equals(enumCode);
                    }
                    return true;
                }).forEach(item -> list.add(item));
            }
            return null;
        });
        return list;
    }

    public List<DictItem> findAllDictItems(String tenantCode) {
        return this.findDictItemsByCode(null, null, tenantCode);
    }

    public List<DictItem> findAllDictItems() {
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        return this.findAllDictItems(tenantCode);
    }

    public List<DictItem> findDictItems(String enumId, String enumCode) {
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        return this.findDictItems(enumId, enumCode, tenantCode);
    }

    public List<DictItem> findDictItems(String enumId, String enumCode, Map<String, Object> context) {
        String tenantCode = Optional.ofNullable(context.get(ContextKeys.StringKeys.TENANTCODE_KEY.name())).map(x -> x.toString()).orElse(null);
        return this.findDictItems(enumId, enumCode, tenantCode);
    }

    public List<DictItem> findDictItemsByCode(String code, String enumCode) {
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        return this.findDictItemsByCode(code, enumCode, tenantCode);
    }
}

