package com.xforceplus.ultraman.metadata.sync.transfer.autoconfigure;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.metadata.sync.transfer.listener.SdkMetadataListener;
import com.xforceplus.ultraman.metadata.sync.transfer.listener.SpringRePublisher;
import com.xforceplus.ultraman.metadata.sync.transfer.service.impl.DictServiceImpl;
import com.xforceplus.ultraman.sdk.infra.Eagerness;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.transfer.client.config.BocpClientConfiguration;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import com.xforceplus.ultraman.transfer.common.event.publisher.EventStream;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

import java.util.List;

@AutoConfigureAfter(BocpClientConfiguration.class)
@ConditionalOnProperty(value = "xplat.oqsengine.sdk.enabled", matchIfMissing = true)
public class BocpTransferAutoConfiguration {

    @Bean
    public DictService dictService(ContextService contextService, MetadataEngine metadataEngine) {
        return new DictServiceImpl(contextService, metadataEngine);
    }

    @Bean
    public SdkMetadataListener sdkEventConsumer(ApplicationEventPublisher springRePublisher
            , EventStream<SDKMetadataEvent> eventStream, MetadataEngine engine
            , GlobalInited globalInited, List<Eagerness> eagernessList, EventEngine eventEngine, Environment environment) {
        SdkMetadataListener sdkMetadataListener = new SdkMetadataListener(engine, globalInited
                , eventEngine, springRePublisher, environment, eagernessList);
        eventStream.subscribe(sdkMetadataListener::onApplicationEvent);
        return sdkMetadataListener;
    }
}
