package com.xforceplus.ultraman.metadata.sync.transfer.listener;

import com.xforceplus.metadata.schema.App;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.AppNode;
import com.xforceplus.metadata.schema.typed.DynamicNode;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.sync.transfer.utils.DomainConverter;
import com.xforceplus.ultraman.sdk.infra.Eagerness;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.transfer.common.event.MetadataDeployEvent;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/4/23 18:56
 * Description:
 * History:
 */
@Slf4j
public class SdkMetadataListener implements SmartInitializingSingleton {

    private MetadataEngine engine;

    private GlobalInited globalInited;

    private EventEngine eventEngine;

    private ApplicationEventPublisher publisher;

    private Boolean isPublisherInited = false;

    private List<MetadataDeployEvent> stash = new ArrayList<>();

    private Environment environment;

    private List<Eagerness> eagernessList = Collections.emptyList();

    public SdkMetadataListener(MetadataEngine engine
            , GlobalInited globalInited
            , EventEngine eventEngine, ApplicationEventPublisher publisher
            , Environment environment
            , List<Eagerness> eagernessList
    ) {
        this.engine = engine;
        this.globalInited = globalInited;
        this.eventEngine = eventEngine;
        this.publisher = publisher;
        this.environment = environment;
        this.eagernessList = eagernessList;
    }

    //    @Async
    //  @EventListener({SDKMetadataEvent.class})
    public void onApplicationEvent(MetadataDeployEvent event) {
        if (event instanceof SDKMetadataEvent) {
            String[] activeProfiles = environment.getActiveProfiles();
            String env;
            if (activeProfiles.length > 0) {
                env = activeProfiles[0];
            } else {
                env = "";
            }
            AppNode appNode = DomainConverter.toAppNode((SDKMetadataEvent) event, env);
            engine.save(appNode);
            globalInited.moduleSaved();
            Optional.ofNullable(eagernessList)
                    .orElseGet(Collections::emptyList)
                    .forEach(x -> {
                        try {
                            x.onInit(appNode);
                        } catch (Throwable throwable) {
                            log.error("{}", throwable);
                        }
                    });
            eventEngine.trigger(UltramanLifecycle.METADATA_REFRESHED, appNode);
            if (!isPublisherInited) {
                stash.add(event);
            } else {
                publisher.publishEvent(event);
            }
        }
    }

    public void setEngine(MetadataEngine engine) {
        this.engine = engine;
    }

    public void setGlobalInited(GlobalInited globalInited) {
        this.globalInited = globalInited;
    }

    public void setEventEngine(EventEngine eventEngine) {
        this.eventEngine = eventEngine;
    }

    @Override
    public void afterSingletonsInstantiated() {
        isPublisherInited = true;
        for (MetadataDeployEvent evt : stash) {
            publisher.publishEvent(evt);
        }
    }
}