/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.transfer.listener;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.AppNode;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.sync.transfer.utils.DomainConverter;
import com.xforceplus.ultraman.sdk.infra.Eagerness;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import com.xforceplus.ultraman.transfer.common.event.MetadataDeployEvent;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;

public class SdkMetadataListener
implements SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(SdkMetadataListener.class);
    private MetadataEngine engine;
    private GlobalInited globalInited;
    private EventEngine eventEngine;
    private ApplicationEventPublisher publisher;
    private Boolean isPublisherInited = false;
    private List<MetadataDeployEvent> stash = new ArrayList<MetadataDeployEvent>();
    private Environment environment;
    private List<Eagerness> eagernessList = Collections.emptyList();

    public SdkMetadataListener(MetadataEngine engine, GlobalInited globalInited, EventEngine eventEngine, ApplicationEventPublisher publisher, Environment environment, List<Eagerness> eagernessList) {
        this.engine = engine;
        this.globalInited = globalInited;
        this.eventEngine = eventEngine;
        this.publisher = publisher;
        this.environment = environment;
        this.eagernessList = eagernessList;
    }

    public void onApplicationEvent(MetadataDeployEvent event) {
        if (event instanceof SDKMetadataEvent) {
            String[] activeProfiles = this.environment.getActiveProfiles();
            String env = activeProfiles.length > 0 ? activeProfiles[0] : "";
            AppNode appNode = DomainConverter.toAppNode((SDKMetadataEvent)event, env);
            this.engine.save(appNode);
            this.globalInited.moduleSaved();
            Optional.ofNullable(this.eagernessList).orElseGet(Collections::emptyList).forEach(x -> {
                try {
                    x.onInit((Object)appNode);
                }
                catch (Throwable throwable) {
                    LoggingUtils.logErrorPattern((Logger)log, (LoggingPattern)LoggingPattern.UNKNOWN_ERROR, () -> "EagernessOnInit:".concat(x.name()), (Throwable)throwable);
                }
            });
            this.eventEngine.trigger(UltramanLifecycle.METADATA_REFRESHED, (Object)appNode);
            if (!this.isPublisherInited.booleanValue()) {
                this.stash.add(event);
            } else {
                this.publisher.publishEvent((Object)event);
            }
        }
    }

    public void setEngine(MetadataEngine engine) {
        this.engine = engine;
    }

    public void setGlobalInited(GlobalInited globalInited) {
        this.globalInited = globalInited;
    }

    public void setEventEngine(EventEngine eventEngine) {
        this.eventEngine = eventEngine;
    }

    public void afterSingletonsInstantiated() {
        this.isPublisherInited = true;
        for (MetadataDeployEvent evt : this.stash) {
            this.publisher.publishEvent((Object)evt);
        }
    }
}

