package com.xforceplus.ultraman.metadata.sync.transfer.autoconfigure;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.metadata.sync.transfer.configurer.BoConfigurer;
import com.xforceplus.ultraman.metadata.sync.transfer.listener.SdkMetadataListener;
import com.xforceplus.ultraman.metadata.sync.transfer.service.impl.DictServiceImpl;
import com.xforceplus.ultraman.sdk.infra.Eagerness;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.transfer.client.config.BocpClientConfiguration;
import com.xforceplus.ultraman.transfer.client.config.BocpClientSetting;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import com.xforceplus.ultraman.transfer.common.event.publisher.EventStream;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@AutoConfigureAfter(BocpClientConfiguration.class)
@ConditionalOnProperty(value = "xplat.oqsengine.sdk.enabled", matchIfMissing = true)
public class BocpTransferAutoConfiguration {

    @Bean
    public DictService dictService(ContextService contextService, MetadataEngine metadataEngine) {
        return new DictServiceImpl(contextService, metadataEngine);
    }

    @Bean
    public SdkMetadataListener sdkEventConsumer(ApplicationEventPublisher springRePublisher
            , EventStream<SDKMetadataEvent> eventStream, MetadataEngine engine
            , GlobalInited globalInited, List<Eagerness> eagernessList, EventEngine eventEngine, Environment environment
            , Optional<List<BoConfigurer>> configurersOp) {
        SdkMetadataListener sdkMetadataListener = new SdkMetadataListener(engine, globalInited
                , eventEngine, springRePublisher, environment, eagernessList
                , configurersOp.orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(BoConfigurer::getName)));
        eventStream.subscribe(sdkMetadataListener::onApplicationEvent);
        return sdkMetadataListener;
    }
}
