/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.transfer.listener;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.AppNode;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.sync.transfer.utils.DomainConverter;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.transfer.common.event.MetadataDeployEvent;
import com.xforceplus.ultraman.transfer.common.event.SDKMetadataEvent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationEventPublisher;

public class SdkMetadataListener
implements SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(SdkMetadataListener.class);
    private MetadataEngine engine;
    private GlobalInited globalInited;
    private EventEngine eventEngine;
    private ApplicationEventPublisher publisher;
    private Boolean isPublisherInited = false;
    private List<MetadataDeployEvent> stash = new ArrayList<MetadataDeployEvent>();

    public SdkMetadataListener(MetadataEngine engine, GlobalInited globalInited, EventEngine eventEngine, ApplicationEventPublisher publisher) {
        this.engine = engine;
        this.globalInited = globalInited;
        this.eventEngine = eventEngine;
        this.publisher = publisher;
    }

    public void onApplicationEvent(MetadataDeployEvent event) {
        if (event instanceof SDKMetadataEvent) {
            AppNode appNode = DomainConverter.toAppNode((SDKMetadataEvent)event);
            this.engine.save(appNode);
            this.globalInited.moduleSaved();
            this.eventEngine.trigger(UltramanLifecycle.METADATA_REFRESHED, (Object)appNode);
            if (!this.isPublisherInited.booleanValue()) {
                this.stash.add(event);
            } else {
                this.publisher.publishEvent((Object)event);
            }
        }
    }

    public void setEngine(MetadataEngine engine) {
        this.engine = engine;
    }

    public void setGlobalInited(GlobalInited globalInited) {
        this.globalInited = globalInited;
    }

    public void setEventEngine(EventEngine eventEngine) {
        this.eventEngine = eventEngine;
    }

    public void afterSingletonsInstantiated() {
        this.isPublisherInited = true;
        for (MetadataDeployEvent evt : this.stash) {
            this.publisher.publishEvent((Object)evt);
        }
    }
}

