/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.transfer.service.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.dsl.utils.MatcherHelper;
import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.vo.dto.DictItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ResponseList;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.sdk.infra.CacheLike;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;

public class DictServiceImpl
implements DictService,
CacheLike,
Refreshable {
    private final ContextService contextService;
    private MetadataEngine metadataEngine;
    private LoadingCache<Tuple2<String, String>, List<DictItem>> dictCache;
    private LoadingCache<Tuple2<String, String>, List<DictItem>> dictCodeCache;

    public DictServiceImpl(ContextService contextService, MetadataEngine metadataEngine) {
        this.metadataEngine = metadataEngine;
        this.contextService = contextService;
        this.dictCache = Caffeine.newBuilder().maximumSize(1000L).build(tuple -> {
            String dictId = (String)tuple._1;
            String tenantCode = (String)tuple._2;
            return (List)metadataEngine.raw(g -> {
                Map next;
                GraphTraversal has = g.traversal().V(new Object[0]).has("nodeLabel", (Object)"Dict");
                if (dictId != null) {
                    has = has.has("publicId", (Object)dictId);
                }
                GraphTraversal traversal = has.has("profile", P.within((Object[])new String[]{null, tenantCode})).as("a", new String[0]).outE(new String[]{MetadataRelationType.HAS_ITEM.name()}).inV().as("b", new String[0]).select("a", "b", new String[0]).by((Traversal)__.valueMap((String[])new String[0])).group().by("a");
                ResponseList candidateProfile = new ResponseList();
                ResponseList candidateNonProfile = new ResponseList();
                if (traversal.hasNext() && (next = (Map)traversal.next()) != null) {
                    next.forEach((key, value) -> {
                        Map keyMap = (Map)key;
                        List valueList = (List)value;
                        String profile = this.getFromMap(keyMap, "profile");
                        List<DictItem> dictItems = this.toDictItems(keyMap, valueList);
                        if (!StringUtils.isEmpty((String)profile)) {
                            candidateProfile.addAll(dictItems);
                        } else {
                            candidateNonProfile.addAll(dictItems);
                        }
                    });
                    if (candidateProfile.isEmpty()) {
                        return candidateNonProfile;
                    }
                    return candidateProfile;
                }
                return null;
            });
        });
        this.dictCodeCache = Caffeine.newBuilder().maximumSize(1000L).build(tuple -> {
            String code = (String)tuple._1;
            String tenantCode = (String)tuple._2;
            return (List)metadataEngine.raw(g -> {
                Map next;
                GraphTraversal has = g.traversal().V(new Object[0]).has("nodeLabel", (Object)"Dict");
                if (code != null) {
                    has = has.has("code", (P)MatcherHelper.caseInsensitiveEq((String)code));
                }
                GraphTraversal traversal = has.has("profile", P.within((Object[])new String[]{null, tenantCode})).as("a", new String[0]).outE(new String[]{MetadataRelationType.HAS_ITEM.name()}).inV().as("b", new String[0]).select("a", "b", new String[0]).by((Traversal)__.valueMap((String[])new String[0])).group().by("a");
                ResponseList candidateProfile = new ResponseList();
                ResponseList candidateNonProfile = new ResponseList();
                if (traversal.hasNext() && (next = (Map)traversal.next()) != null) {
                    next.forEach((key, value) -> {
                        Map keyMap = (Map)key;
                        String profile = this.getFromMap(keyMap, "profile");
                        List valueList = (List)value;
                        List<DictItem> dictItems = this.toDictItems(keyMap, valueList);
                        if (!StringUtils.isEmpty((String)profile)) {
                            candidateProfile.addAll(dictItems);
                        } else {
                            candidateNonProfile.addAll(dictItems);
                        }
                    });
                    return Optional.ofNullable(candidateProfile).orElse(candidateNonProfile);
                }
                return null;
            });
        });
    }

    public List<DictItem> findDictItems(String dictId, String enumCode, String tenantCode) {
        List dictItems = (List)this.dictCache.get((Object)Tuple.of((Object)dictId, (Object)tenantCode));
        return (List)Optional.ofNullable(dictItems).orElseGet(Collections::emptyList).stream().filter(item -> {
            if (enumCode != null) {
                return item.getValue().equals(enumCode);
            }
            return true;
        }).collect(Collectors.toCollection(ResponseList::new));
    }

    private String getFromMap(Map<String, Object> main, String key) {
        return Optional.ofNullable(main.get(key)).map(x -> (List)x).filter(x -> !x.isEmpty()).map(x -> x.get(0)).map(Object::toString).orElse(null);
    }

    private List<DictItem> toDictItems(Map<String, Object> main, List<Map<String, Object>> itemMap) {
        String id = this.getFromMap(main, "id");
        String code = this.getFromMap(main, "code");
        String name = this.getFromMap(main, "name");
        return (List)itemMap.stream().map(x -> {
            DictItem item = new DictItem();
            item.setDictName(name);
            item.setDictId(id);
            item.setDictCode(code);
            Object b = x.get("b");
            if (b != null) {
                Map detailMap = (Map)b;
                String detailCode = this.getFromMap(detailMap, "code");
                String detailName = this.getFromMap(detailMap, "name");
                String detailIcon = this.getFromMap(detailMap, "icon");
                String index = this.getFromMap(detailMap, "index");
                item.setValue(detailCode);
                item.setText(detailName);
                item.setIcon(detailIcon);
                item.setIndex(Optional.ofNullable(index).map(Integer::parseInt).orElse(0).intValue());
            }
            return item;
        }).sorted(Comparator.comparingInt(DictItem::getIndex)).collect(Collectors.toCollection(ResponseList::new));
    }

    public List<DictItem> findDictItemsByCode(String code, String enumCode, String tenantCode) {
        return (List)Optional.ofNullable(this.dictCodeCache.get((Object)Tuple.of((Object)code, (Object)tenantCode))).orElseGet(Collections::emptyList).stream().filter(item -> {
            if (enumCode != null) {
                return item.getValue().equals(enumCode);
            }
            return true;
        }).collect(Collectors.toCollection(ResponseList::new));
    }

    public List<DictItem> findAllDictItems(String tenantCode) {
        return this.findDictItemsByCode(null, null, tenantCode);
    }

    public List<DictItem> findAllDictItems() {
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        return this.findAllDictItems(tenantCode);
    }

    public Integer findEnumIndex(List<DictItem> dictItems, String value) {
        Optional<DictItem> first = dictItems.stream().filter(x -> x.getValue().equalsIgnoreCase(value)).findFirst();
        if (first.isPresent()) {
            return Double.valueOf(Math.pow(2.0, first.get().getIndex())).intValue();
        }
        return 0;
    }

    public List<DictItem> findDictItems(String enumId, String enumCode) {
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        return this.findDictItems(enumId, enumCode, tenantCode);
    }

    public List<DictItem> findDictItems(String enumId, String enumCode, Map<String, Object> context) {
        String tenantCode = Optional.ofNullable(context.get(ContextKeys.StringKeys.TENANTCODE_KEY.name())).map(x -> x.toString()).orElse(null);
        return this.findDictItems(enumId, enumCode, tenantCode);
    }

    public List<DictItem> findDictItemsByCode(String code, String enumCode) {
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        return this.findDictItemsByCode(code, enumCode, tenantCode);
    }

    public void onRefresh(Object payload) {
        this.refreshCache();
    }

    public void refreshCache() {
        this.dictCache.invalidateAll();
        this.dictCodeCache.invalidateAll();
    }
}

