/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.transfer.listener;

import com.typesafe.config.Config;
import com.xforceplus.ultraman.agent.model.MigrateRequest;
import com.xforceplus.ultraman.client.api.AgentApi;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.event.DDLChangedEvent;
import com.xforceplus.ultraman.sdk.infra.utils.ConfigUtils;
import com.xforceplus.ultraman.transfer.domain.entity.DdlContent;
import com.xforceplus.ultraman.transfer.domain.entity.DdlDetail;
import com.xforceplus.ultraman.transfer.domain.entity.Response;
import com.xforceplus.ultraman.transfer.domain.entity.TenantAppDeployInfo;
import com.xforceplus.ultraman.transfer.domain.entity.TransferMessage;
import io.vavr.Tuple2;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.xerces.impl.dv.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class SDKDDLListener {
    private static final Logger log = LoggerFactory.getLogger(SDKDDLListener.class);
    @Autowired
    private AgentApi agentApi;
    @Autowired
    private AuthConfig authConfig;
    @Autowired
    private Environment env;
    @Autowired
    private EntityClassEngine engine;

    public DDLChangedEvent onDDLChange(Tuple2<TransferMessage, Future<Response>> event) {
        try {
            TransferMessage transferMessage = (TransferMessage)event._1;
            DdlDetail ddlDetail = transferMessage.getDdlDetail();
            if (ddlDetail != null) {
                List tenantApps;
                DdlContent diffContent = ddlDetail.getDiffContent();
                String diffContentCombined = diffContent.getDdls().stream().collect(Collectors.joining("\n"));
                String encodedDiffContent = Base64.encode((byte[])diffContentCombined.getBytes());
                DdlContent fullContent = ddlDetail.getFullContent();
                String fullContentCombined = fullContent.getDdls().stream().collect(Collectors.joining("\n"));
                String encodedFullContent = Base64.encode((byte[])fullContentCombined.getBytes());
                MigrateRequest migrateRequest = new MigrateRequest();
                migrateRequest.setDiffContent(encodedDiffContent);
                migrateRequest.setFullContent(encodedFullContent);
                migrateRequest.setEnv(this.authConfig.getEnv());
                migrateRequest.setVersion(transferMessage.getVersion());
                migrateRequest.setOriginVersion(transferMessage.getOriginVersion());
                if (transferMessage.getDdlDetail().isTenantApp() && !(tenantApps = transferMessage.getDeployDetail().getTenantApps()).isEmpty()) {
                    migrateRequest.setVersion(((TenantAppDeployInfo)tenantApps.get(0)).getDeployVersion());
                    migrateRequest.setOriginVersion(((TenantAppDeployInfo)tenantApps.get(0)).getOriginVersion());
                }
                migrateRequest.setProject(this.authConfig.getAppCode());
                Config config = ConfigUtils.getConfig((Environment)this.env);
                List configList = ConfigUtils.getDSConfigList((Config)config);
                boolean isTenant = false;
                if (configList.size() > 1) {
                    isTenant = true;
                }
                Config mainDSConfig = (Config)configList.get(0);
                migrateRequest.setTenant(isTenant);
                migrateRequest.setJdbcUrl(mainDSConfig.getString("jdbcUrl"));
                migrateRequest.setWaiting(true);
                migrateRequest.setAllowFull(true);
                com.xforceplus.ultraman.agent.model.Response migrate = this.agentApi.migrate(migrateRequest);
                if (migrate.getCode() == 1) {
                    Response response = new Response();
                    response.setCode("1");
                    ((CompletableFuture)event._2()).complete(response);
                } else if (migrate.getCode() == -2) {
                    log.warn("\u5e76\u53d1\u4fee\u6539\u6570\u636e\u5e93");
                } else {
                    Response response = new Response();
                    response.setCode("-1");
                    response.setMessage("\u8fc1\u79fbDDL\u6267\u884c\u5931\u8d25:" + migrate.getMessage());
                    ((CompletableFuture)event._2()).complete(response);
                }
            }
        }
        catch (Throwable throwable) {
            Response response = new Response();
            response.setCode("-1");
            response.setMessage("\u6267\u884cDDL\u5f02\u5e38,\u8bf7\u91cd\u8bd5\u6216\u8005\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458, \u5f02\u5e38\u539f\u56e0:" + throwable.getMessage());
            ((CompletableFuture)event._2()).complete(response);
        }
        return new DDLChangedEvent();
    }
}

