/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.transfer.message;

import com.google.common.collect.ImmutableMap;
import com.xforceplus.ultraman.metadata.message.MetadataMessageSource;
import com.xforceplus.ultraman.sdk.infra.api.ProfileFetcher;
import com.xforceplus.ultraman.sdk.infra.message.MessageResource;
import com.xforceplus.ultraman.transfer.common.context.MetadataI18nContextHolder;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.AbstractMessageSource;

public class BocpMessageSource
extends AbstractMessageSource
implements MetadataMessageSource {
    @Autowired
    private ProfileFetcher profileFetcher;

    protected MessageFormat resolveCode(String code, Locale locale) {
        try {
            ImmutableMap i18nResourceMap = MetadataI18nContextHolder.getTenantI18nResourceMap((String)"OQS_SDK", (String)this.profileFetcher.getProfile(Collections.emptyMap()));
            if (i18nResourceMap != null) {
                String value;
                ImmutableMap localed = (ImmutableMap)i18nResourceMap.get((Object)locale.toLanguageTag());
                if (localed == null) {
                    localed = (ImmutableMap)i18nResourceMap.get((Object)"zh-CN");
                }
                if (localed != null && (value = (String)localed.get((Object)code)) != null) {
                    return new MessageFormat(value, locale);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public String res(MessageResource messageResource) {
        return this.getMessage(messageResource.getMessageKey(), null, messageResource.getMessageValue(), LocaleContextHolder.getLocale());
    }

    public String res(MessageResource messageResource, String ... args) {
        return this.getMessage(messageResource.getMessageKey(), args, messageResource.getMessageValue(), LocaleContextHolder.getLocale());
    }
}

