/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.transfer.settings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.xforceplus.metadata.schema.typed.DynamicNode;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaSdkSetting;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import io.vavr.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkSettingsHelper {
    private static final Logger log = LoggerFactory.getLogger(SdkSettingsHelper.class);
    private static final TypeReference<Map<String, String>> typeRefer = new TypeReference<Map<String, String>>(){};
    private static final String SDK = "sdk20";
    private static final String ENV = "env";

    public static List<DynamicNode> getNode(List<SchemaSdkSetting> settings, String configEnv) {
        List filtered = settings.stream().filter(x -> x.getType().equals(SDK)).map(x -> {
            String setting = x.getSetting();
            try {
                Map envSettings = (Map)JacksonDefaultMapper.OBJECT_MAPPER.readValue(setting, typeRefer);
                boolean hasEnv = envSettings.containsKey(ENV);
                if (hasEnv) {
                    String env = (String)envSettings.get(ENV);
                    return Tuple.of((Object)env, (Object)envSettings);
                }
                return Tuple.of((Object)"", (Object)envSettings);
            }
            catch (Throwable throwable) {
                log.error("Got Error while parsing SDK-SETTING {}", (Object)throwable.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).filter(x -> {
            String env = (String)x._1;
            if ("".equals(env)) {
                return true;
            }
            return configEnv.equalsIgnoreCase(env);
        }).map(tuple -> SdkSettingsHelper.mapOneNode((Map)tuple._2, (String)tuple._1)).reduce(new ArrayList(), (a, b) -> {
            ArrayList<DynamicNode> retList = new ArrayList<DynamicNode>((Collection<DynamicNode>)a);
            for (DynamicNode b1 : b) {
                if (a.isEmpty()) {
                    retList.add(b1);
                    continue;
                }
                for (DynamicNode a1 : a) {
                    if (a1.getName().equals(b1.getName())) {
                        if (StringUtils.isEmpty((CharSequence)b1.getEnv())) continue;
                        retList.remove(a1);
                        retList.add(b1);
                        continue;
                    }
                    retList.add(b1);
                }
            }
            return retList;
        });
        return filtered;
    }

    private static List<DynamicNode> mapOneNode(Map<String, String> properties, String env) {
        ArrayList<DynamicNode> nodes = new ArrayList<DynamicNode>();
        try {
            Map<String, String> settings = properties;
            settings.entrySet().stream().forEach(en -> {
                String value = (String)en.getValue();
                String unescapeJson = StringEscapeUtils.unescapeJava((String)value);
                Object targetValue = null;
                try {
                    targetValue = JacksonDefaultMapper.OBJECT_MAPPER.readValue(unescapeJson, Map.class);
                }
                catch (JsonProcessingException e) {
                    targetValue = value;
                }
                if (targetValue instanceof Map) {
                    Map valueMap = (Map)targetValue;
                    Object main = null;
                    if (valueMap.containsKey("main")) {
                        Object tenant;
                        main = valueMap.get("main");
                        DynamicNode defaultNode = new DynamicNode();
                        defaultNode.setEnv(env);
                        defaultNode.setName((String)en.getKey());
                        defaultNode.setProfile(null);
                        try {
                            defaultNode.setJson(JacksonDefaultMapper.OBJECT_MAPPER.writeValueAsString(main));
                        }
                        catch (JsonProcessingException e) {
                            e.printStackTrace();
                        }
                        nodes.add(defaultNode);
                        if (main instanceof Map && valueMap.containsKey("tenant") && (tenant = valueMap.get("tenant")) instanceof Map) {
                            Map tenantMap = (Map)tenant;
                            Object finalMain = main;
                            tenantMap.entrySet().stream().forEach(x -> {
                                Object tenantValue = x.getValue();
                                if (tenantValue instanceof Map) {
                                    DynamicNode dynamicNode = new DynamicNode();
                                    dynamicNode.setName((String)en.getKey());
                                    dynamicNode.setEnv(env);
                                    dynamicNode.setProfile((String)x.getKey());
                                    HashMap newMap = new HashMap(finalMain);
                                    newMap.putAll((Map)tenantValue);
                                    try {
                                        dynamicNode.setJson(JacksonDefaultMapper.OBJECT_MAPPER.writeValueAsString(newMap));
                                    }
                                    catch (JsonProcessingException e) {
                                        e.printStackTrace();
                                    }
                                    nodes.add(dynamicNode);
                                }
                            });
                        }
                    } else {
                        DynamicNode dynamicNode = new DynamicNode();
                        dynamicNode.setName((String)en.getKey());
                        dynamicNode.setProfile(null);
                        dynamicNode.setEnv(env);
                        try {
                            dynamicNode.setJson(JacksonDefaultMapper.OBJECT_MAPPER.writeValueAsString(targetValue));
                        }
                        catch (JsonProcessingException e) {
                            e.printStackTrace();
                        }
                        nodes.add(dynamicNode);
                    }
                } else {
                    DynamicNode dynamicNode = new DynamicNode();
                    dynamicNode.setName((String)en.getKey());
                    dynamicNode.setProfile(null);
                    dynamicNode.setEnv(env);
                    dynamicNode.setJson(targetValue.toString());
                    nodes.add(dynamicNode);
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return nodes;
    }
}

