package com.xforceplus.ultraman.metadata.sync.transfer.listener;

import com.typesafe.config.Config;
import com.xforceplus.ultraman.agent.model.MigrateRequest;
import com.xforceplus.ultraman.client.api.AgentApi;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.event.DDLChangedEvent;
import com.xforceplus.ultraman.sdk.infra.utils.ConfigUtils;
import com.xforceplus.ultraman.transfer.domain.entity.*;
import io.vavr.Tuple2;
import lombok.extern.slf4j.Slf4j;
import org.apache.xerces.impl.dv.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

import static com.xforceplus.ultraman.sdk.infra.utils.ConfigUtils.getDSConfigList;

@Slf4j
public class SDKDDLListener  {
    
    @Autowired
    private AgentApi agentApi;
    
    @Autowired
    private AuthConfig authConfig;
    
    @Autowired
    private Environment env;
    
    @Autowired
    private EntityClassEngine engine;
    
    public DDLChangedEvent onDDLChange(Tuple2<TransferMessage, Future<Response>> event) {
        try {
            TransferMessage transferMessage = event._1;
            DdlDetail ddlDetail = transferMessage.getDdlDetail();
            if (ddlDetail != null) {
                DdlContent diffContent = ddlDetail.getDiffContent();
                String diffContentCombined = diffContent.getDdls().stream().collect(Collectors.joining("\n"));
                String encodedDiffContent = Base64.encode(diffContentCombined.getBytes());

                DdlContent fullContent = ddlDetail.getFullContent();
                String fullContentCombined = fullContent.getDdls().stream().collect(Collectors.joining("\n"));
                String encodedFullContent = Base64.encode(fullContentCombined.getBytes());

                MigrateRequest migrateRequest = new MigrateRequest();
                migrateRequest.setDiffContent(encodedDiffContent);
                migrateRequest.setFullContent(encodedFullContent);
                migrateRequest.setEnv(authConfig.getEnv());
                //current date?
                migrateRequest.setVersion(transferMessage.getVersion());
                migrateRequest.setOriginVersion(transferMessage.getOriginVersion());

                if(transferMessage.getDdlDetail().isTenantApp()) {
                    List<TenantAppDeployInfo> tenantApps = transferMessage.getDeployDetail().getTenantApps();
                    if(!tenantApps.isEmpty()) {
                        migrateRequest.setVersion(tenantApps.get(0).getDeployVersion());
                        migrateRequest.setOriginVersion(tenantApps.get(0).getOriginVersion());
                    }
                }

                migrateRequest.setProject(authConfig.getAppCode());
                Config config = ConfigUtils.getConfig(env);
                List<Config> configList = getDSConfigList(config);
                boolean isTenant = false;
                if(configList.size() > 1) {
                    isTenant = true;
                }
                
                Config mainDSConfig = configList.get(0);
                migrateRequest.setTenant(isTenant);
                migrateRequest.setJdbcUrl(mainDSConfig.getString("jdbcUrl"));
                migrateRequest.setWaiting(true);
                migrateRequest.setAllowFull(true);
                com.xforceplus.ultraman.agent.model.Response migrate = agentApi.migrate(migrateRequest);
                if(migrate.getCode() == 1) {
                    Response response = new Response();
                    response.setCode("1");
                    ((CompletableFuture<Response>) event._2()).complete(response);
                } else {
                    if(migrate.getCode() == -2) {
                        //concurrent
                        //do nothing here
                        log.warn("并发修改数据库");
                    } else {
                        Response response = new Response();
                        response.setCode("-1");
                        response.setMessage("迁移DDL执行失败:" + migrate.getMessage());
                        ((CompletableFuture<Response>) event._2()).complete(response);
                    }
                }
            }
        } catch (Throwable throwable){
            Response response = new Response();
            response.setCode("-1");
            response.setMessage("执行DDL异常,请重试或者联系平台管理员, 异常原因:" + throwable.getMessage() );
            ((CompletableFuture<Response>) event._2()).complete(response);
        } 
        return new DDLChangedEvent();
    }
    
//    private String getMainJdbcUrl(Config config) {
//        Object anyRef = config.getAnyRef(DATA_SOURCES);
//        Config mainConfig = null;
//        if(anyRef instanceof List) {
//            List<? extends Config> configList = config.getConfigList(DATA_SOURCES);
//            if(((List<Config>) anyRef).isEmpty()) {
//                throw new RuntimeException("至少配置一个数据源");
//            }
//          
//            //TODO how to do batchMode
//            mainConfig = configList.get(0);
//
//        } else {
//            ConfigObject configObject = config.getObject(DATA_SOURCES);
//            if (configObject.isEmpty()) {
//                throw new RuntimeException("至少配置一个数据源");
//            }
//
//            if (config.hasPath("dataSources.master")) {
//                List<Config> configList = (List<Config>)config.getConfigList("dataSources.master");
//                mainConfig = configList.get(0);
//            }
//        }
//        
//        if(mainConfig != null) {
//            return mainConfig.getString("jdbcUrl");
//        }
//
//        throw new RuntimeException("No Master datasource config");
//    }
//    
//    private Config getConfig() {
//        String baseName = "oqs-datasource";
//        Config baseConfig = ConfigFactory.load(baseName);
//        Config config = null;
//        String[] activeProfiles = env.getActiveProfiles();
//        if(activeProfiles.length > 0) {
//            String activeProfile = activeProfiles[0];
//            if(!activeProfile.equalsIgnoreCase("DEFAULT") && !StringUtils.isEmpty(activeProfile)) {
//                //try find
//                try {
//                    Config extend = ConfigFactory.load("oqs-datasource-".concat(activeProfile));
//                    config = extend.withFallback(baseConfig).resolve();
//                } catch (Throwable throwable) {
//                    //slient
//                    log.warn("Cannot find related {}", activeProfile);
//                }
//            }
//        }
//
//        if(config == null) {
//            config = baseConfig;
//        }
//        
//        return config;
//    }
}
