package com.xforceplus.ultraman.metadata.sync.transfer.message;

import com.google.common.collect.ImmutableMap;
import com.xforceplus.ultraman.metadata.message.MetadataMessageSource;
import com.xforceplus.ultraman.sdk.infra.api.ProfileFetcher;
import com.xforceplus.ultraman.sdk.infra.message.MessageResource;
import com.xforceplus.ultraman.transfer.common.context.MetadataI18nContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.AbstractMessageSource;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;

/**
 * TODO
 */
public class BocpMessageSource extends AbstractMessageSource implements MetadataMessageSource {
    
    @Autowired
    private ProfileFetcher profileFetcher;

    @Override
    protected MessageFormat resolveCode(String code, Locale locale) {
        try {
            ImmutableMap<String, ImmutableMap<String, String>> i18nResourceMap = MetadataI18nContextHolder
                    .getTenantI18nResourceMap("OQS_SDK", profileFetcher.getProfile(Collections.emptyMap()));

            if (i18nResourceMap != null) {
                ImmutableMap<String, String> localed = i18nResourceMap.get(locale.toLanguageTag());
                if (localed == null) {
                    //fallback to  zh-CN
                    localed = i18nResourceMap.get("zh-CN");
                }

                if (localed != null) {
                    String value = localed.get(code);
                    if (value != null) {
                        return new MessageFormat(value, locale);
                    }
                }
            }
        } catch (Throwable throwable) {
            
        }
        
        //after all using defaultValue from code
        return null;
    }
    
    @Override
    public String res(MessageResource messageResource) {
        //@Nullable Object[] args, @Nullable String defaultMessage, Locale locale
        return this.getMessage(messageResource.getMessageKey()
                , null
                , messageResource.getMessageValue()
                , LocaleContextHolder.getLocale());
    }

    @Override
    public String res(MessageResource messageResource, String... args) {
        //@Nullable Object[] args, @Nullable String defaultMessage, Locale locale
        return this.getMessage(messageResource.getMessageKey()
                , args
                , messageResource.getMessageValue()
                , LocaleContextHolder.getLocale());
    }
}
