package com.xforceplus.ultraman.metadata.sync.transfer.service.impl;

import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.tech.base.core.context.ContextKeys.StringKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.vo.dto.DictItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ResponseList;
import com.xforceplus.ultraman.metadata.service.DictService;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import static com.xforceplus.metadata.schema.dsl.Step.DICT;
import static com.xforceplus.metadata.schema.dsl.utils.MatcherHelper.caseInsensitiveEq;
import static com.xforceplus.metadata.schema.rels.MetadataRelationType.HAS_ITEM;
import static com.xforceplus.metadata.schema.runtime.MetadataEngine.*;

/**
 * TODO
 * move from entityServiceEx
 */
public class DictServiceImpl implements DictService {

    private final ContextService contextService;

    private MetadataEngine metadataEngine;

    public DictServiceImpl(ContextService contextService, MetadataEngine metadataEngine) {
        this.metadataEngine = metadataEngine;
        this.contextService = contextService;
    }

    /**
     * find enumCode with tenantCode and enumId and enumCode
     *
     * @param enumCode
     * @param tenantCode
     * @return
     */
    @Override
    public List<DictItem> findDictItems(String dictId, String enumCode, String tenantCode) {
        ResponseList list = new ResponseList();
        metadataEngine
                .raw(g -> {
                    GraphTraversal<Vertex, Vertex> has = g.traversal().V()
                            .has(LABEL_INDEX, DICT);
                    if (dictId != null) {
                        has = has.has(ID_INDEX, dictId);
                    }

                    GraphTraversal<Vertex, Map<Object, Object>> traversal =
                            has.has("profile", P.within(null, tenantCode))
                                    .as("a")
                                    .outE(HAS_ITEM.name())
                                    .inV().as("b").select("a", "b").by(__.valueMap()).group().by("a");

                    if (traversal.hasNext()) {
                        Map<Object, Object> next = traversal.next();
                        if (next != null) {
                            next.entrySet().stream().flatMap(entry -> {
                                Object key = entry.getKey();
                                Object value = entry.getValue();
                                Map<String, Object> keyMap = (Map<String, Object>) key;
                                List<Map<String, Object>> valueList = (List<Map<String, Object>>) value;
                                return toDictItems(keyMap, valueList).stream();
                            }).filter(item -> {
                                if(enumCode != null) {
                                    return item.getValue().equals(enumCode);
                                } else {
                                    return true;
                                }
                            }).forEach(
                                    item -> {
                                        list.add(item);
                                    }
                            );
                        }
                    }
                    return null;
                });

        return list;
    }

    private String getFromMap(Map<String, Object> main, String key) {
        return Optional.ofNullable(main.get(key))
                .map(x -> (List)x)
                .filter(x -> !x.isEmpty())
                .map(x -> x.get(0))
                .map(Object::toString).orElse(null);
    }

    private List<DictItem> toDictItems(Map<String, Object> main, List<Map<String, Object>> itemMap) {

        String id = getFromMap(main, "id");
        String code = getFromMap(main, "code");
        String name = getFromMap(main, "name");

        return itemMap.stream().map(x -> {
            DictItem item = new DictItem();
            item.setDictName(name);
            item.setDictId(id);
            item.setDictCode(code);

            Object b = x.get("b");
            if (b != null) {
                Map<String, Object> detailMap = (Map<String, Object>) b;
                String detailCode =  getFromMap(detailMap, "code");
                String detailName =  getFromMap(detailMap, "name");
                String detailIcon =  getFromMap(detailMap, "icon");
                String index =  getFromMap(detailMap, "index");

                item.setValue(detailCode);
                item.setText(detailName);
                item.setIcon(detailIcon);
                item.setIndex(Optional.ofNullable(index).map(Integer::parseInt).orElse(0));
            }
            return item;
        }).sorted(Comparator.comparingInt(DictItem::getIndex)).collect(Collectors.toList());
    }

    @Override
    public List<DictItem> findDictItemsByCode(String code, String enumCode, String tenantCode) {
        ResponseList list = new ResponseList();
        metadataEngine
                .raw(g -> {
                    GraphTraversal<Vertex, Vertex> has = g.traversal().V()
                            .has(LABEL_INDEX, DICT);
                    if (code != null) {
                        has = has.has(CODE_INDEX, caseInsensitiveEq(code));
                    }

                    GraphTraversal<Vertex, Map<Object, Object>> traversal =
                            has.has("profile", P.within(null, tenantCode))
                                    .as("a")
                                    .outE(HAS_ITEM.name())
                                    .inV().as("b").select("a", "b").by(__.valueMap()).group().by("a");

                    if (traversal.hasNext()) {
                        Map<Object, Object> next = traversal.next();
                        if (next != null) {
                            next.entrySet().stream().flatMap(entry -> {
                                Object key = entry.getKey();
                                Object value = entry.getValue();
                                Map<String, Object> keyMap = (Map<String, Object>) key;
                                List<Map<String, Object>> valueList = (List<Map<String, Object>>) value;
                                return toDictItems(keyMap, valueList).stream();
                            }).filter(item -> {
                                if(enumCode != null) {
                                    return item.getValue().equals(enumCode);
                                } else {
                                    return true;
                                }
                            }).forEach(
                                    item -> {
                                        list.add(item);
                                    }
                            );
                        }
                    }
                    return null;
                });

        return list;
    }

    @Override
    public List<DictItem> findAllDictItems(String tenantCode) {
        return findDictItemsByCode(null, null, tenantCode);
    }

    @Override
    public List<DictItem> findAllDictItems() {
        String tenantCode = contextService.get(StringKeys.TENANTCODE_KEY);
        return findAllDictItems(tenantCode);
    }

    @Override
    public List<DictItem> findDictItems(String enumId, String enumCode) {
        String tenantCode = contextService.get(StringKeys.TENANTCODE_KEY);
        return findDictItems(enumId, enumCode, tenantCode);
    }

    @Override
    public List<DictItem> findDictItems(String enumId, String enumCode, Map<String, Object> context) {
        String tenantCode = Optional.ofNullable(context.get(StringKeys.TENANTCODE_KEY.name())).map(x -> x.toString()).orElse(null);
        return findDictItems(enumId, enumCode, tenantCode);
    }

    @Override
    public List<DictItem> findDictItemsByCode(String code, String enumCode) {
        String tenantCode = contextService.get(StringKeys.TENANTCODE_KEY);
        return findDictItemsByCode(code, enumCode, tenantCode);
    }
}
