package com.xforceplus.ultraman.metadata.sync.transfer.settings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.xforceplus.metadata.schema.typed.DynamicNode;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.SchemaSdkSetting;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import io.vavr.Tuple;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

import java.util.*;

/**
 * sdk settings helper
 * change sdk -> dynamicNode
 */
@Slf4j
public class SdkSettingsHelper {

    private final static TypeReference<Map<String, String>> typeRefer = new TypeReference<Map<String, String>>() {
    };

    private final static String SDK = "sdk20";

    private final static String ENV = "env";

    /**
     * settings filter
     *
     * @param settings
     * @return
     */
    public static List<DynamicNode> getNode(List<SchemaSdkSetting> settings, String configEnv) {
        List<DynamicNode> filtered = settings.stream().filter(x -> x.getType().equals(SDK))
                .map(x -> {
                    String setting = x.getSetting();
                    try {
                        //value is an escaped String
                        Map<String, String> envSettings = JacksonDefaultMapper.OBJECT_MAPPER.readValue(setting, typeRefer);
                        boolean hasEnv = envSettings.containsKey(ENV);
                        if (hasEnv) {
                            String env = envSettings.get(ENV);
                            return Tuple.of(env, envSettings);
                        } else {
                            return Tuple.of("", envSettings);
                        }
                    } catch (Throwable throwable) {
                        log.error("Got Error while parsing SDK-SETTING {}", throwable.getMessage());
                        return null;
                    }
                }).filter(Objects::nonNull).filter(x -> {
                    String env = x._1;
                    if("".equals(env)){
                        return true;
                    } else {
                        return configEnv.equalsIgnoreCase(env);
                    }
                }).map(tuple -> {
                    return mapOneNode(tuple._2, tuple._1);
                }).reduce(new ArrayList<>(), (a, b) -> {
                    List<DynamicNode> retList = new ArrayList<>(a);
                    for(DynamicNode b1 : b) {
                        if(a.isEmpty()) {
                            retList.add(b1);
                        } else {
                            for (DynamicNode a1 : a) {
                                /**
                                 * same name
                                 */
                                if (a1.getName().equals(b1.getName())) {
                                    if (!StringUtils.isEmpty(b1.getEnv())) {
                                        retList.remove(a1);
                                        retList.add(b1);
                                    }
                                } else {
                                    retList.add(b1);
                                }
                            }
                        }
                    }
                    return retList;
                });

        return filtered;
    }

    private static List<DynamicNode> mapOneNode(Map<String, String> properties, String env) {
        List<DynamicNode> nodes = new ArrayList<>();
        try {
            //value is an escaped String
            Map<String, String> settings = properties;
            settings.entrySet().stream().forEach(en -> {
                String value = en.getValue();
                String unescapeJson = StringEscapeUtils.unescapeJava(value);
                Object targetValue = null;
                try {
                    targetValue = JacksonDefaultMapper.OBJECT_MAPPER.readValue(unescapeJson, Map.class);
                } catch (JsonProcessingException e) {
                    //is plain json;
                    targetValue = value;
                }

                if (targetValue instanceof Map) {
                    //value must be map or skip the config
                    Map<String, Object> valueMap = (Map<String, Object>) targetValue;
                    Object main = null;
                    if (valueMap.containsKey("main")) {
                        main = valueMap.get("main");

                        DynamicNode defaultNode = new DynamicNode();
                        defaultNode.setEnv(env);
                        defaultNode.setName(en.getKey());
                        defaultNode.setProfile(null);
                        try {
                            defaultNode.setJson(JacksonDefaultMapper.OBJECT_MAPPER.writeValueAsString(main));
                        } catch (JsonProcessingException e) {
                            e.printStackTrace();
                        }
                        nodes.add(defaultNode);

                        if (main instanceof Map) {
                            //only map can merge tenant
                            if (valueMap.containsKey("tenant")) {
                                Object tenant = valueMap.get("tenant");
                                //tenant is a map
                                if (tenant instanceof Map) {
                                    Map<String, Object> tenantMap = (Map<String, Object>) tenant;
                                    Object finalMain = main;
                                    tenantMap.entrySet().stream().forEach(x -> {
                                        Object tenantValue = x.getValue();
                                        if (tenantValue instanceof Map) {
                                            DynamicNode dynamicNode = new DynamicNode();
                                            dynamicNode.setName(en.getKey());
                                            dynamicNode.setEnv(env);
                                            dynamicNode.setProfile(x.getKey());
                                            Map<String, Object> newMap = new HashMap<>((Map<String, Object>) finalMain);
                                            newMap.putAll((Map<String, Object>) tenantValue);
                                            try {
                                                dynamicNode.setJson(JacksonDefaultMapper.OBJECT_MAPPER.writeValueAsString(newMap));
                                            } catch (JsonProcessingException e) {
                                                e.printStackTrace();
                                            }
                                            nodes.add(dynamicNode);
                                        }
                                    });
                                }
                            }
                        }
                    } else {
                        DynamicNode dynamicNode = new DynamicNode();
                        dynamicNode.setName(en.getKey());
                        dynamicNode.setProfile(null);
                        dynamicNode.setEnv(env);
                        try {
                            dynamicNode.setJson(JacksonDefaultMapper
                                    .OBJECT_MAPPER.writeValueAsString(targetValue));
                        } catch (JsonProcessingException e) {
                            e.printStackTrace();
                        }
                        nodes.add(dynamicNode);
                    }
                } else {
                    //single configuration
                    DynamicNode dynamicNode = new DynamicNode();
                    dynamicNode.setName(en.getKey());
                    dynamicNode.setProfile(null);
                    dynamicNode.setEnv(env);
                    dynamicNode.setJson(targetValue.toString());
                    nodes.add(dynamicNode);
                }
            });
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return nodes;
    }
}
