/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.engine;

import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EntityClassGroup {
    public static final Logger log = LoggerFactory.getLogger(EntityClassGroup.class);

    default public Stream<Tuple2<IEntityField, Object>> zipValue(Map<String, Object> body, long id) {
        this.testBody(body, id).forEach(x -> log.warn("[{}] is not available in EntityClass [{}]", x, (Object)this.getEntityClass().code()));
        return this.getAllFields().stream().map(x -> {
            String key = x.name().toLowerCase();
            return Tuple.of((Object)x, body.entrySet().stream().filter(y -> ((String)y.getKey()).equalsIgnoreCase(key)).map(y -> y.getValue()).filter(Objects::nonNull).findFirst().orElse(null));
        });
    }

    default public Set<String> testBody(Map<String, Object> map, long targetId) {
        Set<String> inputKeys = map.keySet();
        Set allKeys = this.getAllFields().stream().map(IEntityField::name).collect(Collectors.toSet());
        return inputKeys.stream().filter(x -> !allKeys.contains(x)).collect(Collectors.toSet());
    }

    public Collection<IEntityClass> getFatherEntityClass();

    public Collection<IEntityClass> getChildrenEntityClass();

    public Collection<IRelation> getAllRelations();

    public Collection<IEntityField> getAllFields();

    public Optional<IEntityField> field(String var1);

    public Optional<IEntityField> field(long var1);

    public Optional<IRelation> relation(long var1);

    public Optional<IRelation> relation(String var1);

    public Optional<IEntityClass> relatedEntityClass(String var1);

    public IEntityClass getEntityClass();

    public String profile();

    public EntityClassGroup relatedEntityClassWithRawName(String var1);

    public EntityClassEngine classEngine();

    default public EntityClassGroup describe(IEntityClass entityClass) {
        String profile = this.getEntityClass().ref().getProfile();
        return this.classEngine().describe(entityClass, profile);
    }

    public Record toRecordNew(Map<Tuple2<String, Long>, Object> var1, long var2);

    public Optional<ColumnField> column(String var1);

    public List<ColumnField> columns(String var1);

    public List<ColumnField> columns();
}

