package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.Collections;
import java.util.Map;

/**
 * 定义公式类型的数据.
 *
 * @author j.xu
 * @version 0.1 2021/05/2021/5/11
 * @since 1.8
 */
public class FormulaTypedValue extends AbstractValue<Map<String, Object>> {

    public FormulaTypedValue(IEntityField field, Map<String, Object> params) {
        super(field, params);
    }

    public FormulaTypedValue(IEntityField field, Map<String, Object> value, Attachment attachment) {
        super(field, value, attachment);
    }

    public FormulaTypedValue(IEntityField field, Map<String, Object> value, String attachemnt) {
        super(field, value, attachemnt);
    }

    @Override
    Map<String, Object> fromString(String value) {
        return Collections.emptyMap();
    }

    @Override
    public long valueToLong() {
        return 0;
    }

    @Override
    protected IValue<Map<String, Object>> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        Attachment attachment = this.getAttachment().copy();
        attachment.add(attachmentKey, attachmentValue);
        return new FormulaTypedValue(newField, getValue(), attachment);
    }

    @Override
    protected IValue<Map<String, Object>> doCopy(Map<String, Object> value) {
        return new FormulaTypedValue(getField(), value, getAttachment().copy());
    }

    @Override
    protected boolean skipTypeCheckWithCopy() {
        return true;
    }

    @Override
    public int compareTo(IValue o) {
        return 0;
    }

    @Override
    public Map<String, Object> storageValue() {
        return null;
    }
}
