/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.values.AbstractValue;
import com.xforceplus.ultraman.metadata.values.Attachment;
import com.xforceplus.ultraman.metadata.values.IValue;

public class BooleanValue
extends AbstractValue<Boolean> {
    public BooleanValue(IEntityField field, Boolean value) {
        super(field, value);
    }

    public BooleanValue(IEntityField field, Boolean value, Attachment attachment) {
        super(field, value, attachment);
    }

    public BooleanValue(IEntityField field, Boolean value, String attachemnt) {
        super(field, value, attachemnt);
    }

    @Override
    Boolean fromString(String value) {
        if (value.equalsIgnoreCase("1")) {
            return true;
        }
        if (value.equalsIgnoreCase("0")) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public long valueToLong() {
        return (Boolean)this.getValue() != false ? 1L : 0L;
    }

    @Override
    public Integer storageValue() {
        return null == this.getValue() || (Boolean)this.getValue() == false ? 0 : 1;
    }

    @Override
    protected IValue<Boolean> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        Attachment attachment = this.getAttachment().copy();
        attachment.add(attachmentKey, attachmentValue);
        return new BooleanValue(newField, (Boolean)this.getValue(), attachment);
    }

    @Override
    protected IValue<Boolean> doCopy(Boolean value) {
        return new BooleanValue(this.getField(), value, this.getAttachment().copy());
    }
}

