package com.xforceplus.ultraman.metadata.entity;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.EntityField;

/**
 * 表示entity 的字段信息.
 * @author dongbin
 * @version 0.1 2020/2/22 16:29
 * @since 1.8
 */
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
public interface IEntityField extends Cloneable{

    IEntityField ID_ENTITY_FIELD =
            new EntityField(0, "id", FieldType.LONG, FieldConfig.build().identifie(true));

    /**
     * 字段标识.
     * @return 标识.
     */
    @JsonGetter("fId")
    long id();

    /**
     * 字段的名称.
     * @return 名称.
     */
    @JsonGetter("fName")
    String name();

    /**
     * 字段的中文名
     * @return
     */
    @JsonGetter("fCName")
    String cnName();

    /**
     * 字段的类型.
     * @return 类型.
     */
    @JsonGetter("ftype")
    FieldType type();

    /**
     * 获取字段配置.
     * @return 配置.
     */
    @JsonGetter("fConfig")
    FieldConfig config();

    /**
     * 获取枚举类型的字典id
     * @return 配置
     */
    @JsonGetter("fDictId")
    String dictId();

    /**
     * 获取默认值信息
     * @return 配置
     */
    @JsonGetter("fDefaultValue")
    String defaultValue();

    default Boolean acceptName(String name){
        return name().equalsIgnoreCase(name);
    }

    IEntityField clone();

    boolean isDynamic();

    CalculationType calculationType();

}
