package com.xforceplus.ultraman.metadata.entity.impl;

import com.xforceplus.metadata.schema.dsl.bo.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.BoField;
import com.xforceplus.metadata.schema.typed.BoIndex;
import com.xforceplus.metadata.schema.typed.BoNode;
import com.xforceplus.metadata.schema.typed.BoRelationship;
import com.xforceplus.ultraman.metadata.entity.*;
import com.xforceplus.ultraman.metadata.helper.VersionUtils;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.utils.ReturnValueModifierProxy;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.structure.Direction;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.xforceplus.metadata.schema.rels.MetadataRelationType.*;
import static com.xforceplus.metadata.schema.runtime.MetadataEngine.ID_INDEX;

/**
 * lazy graph based entityclass
 */
public class LazyEntityClass implements IEntityClass, Refreshable {

    private MetadataEngine metadataEngine;

    private BoNode boNode;

    private EntityClassRef ref;

    private IEntityClass extendedClass = null;

    private Boolean hasParent = null;

    private List<IRelation> relations;

    private List<IEntityField> fields;

    private List<BoIndex> indexes = null;

    public LazyEntityClass(MetadataEngine metadataEngine, String appCode, BoNode boNode) {
        this.metadataEngine = metadataEngine;
        this.boNode = boNode;
        //TODO
        this.ref = new EntityClassRef(Long.parseLong(boNode.getId()), appCode, boNode.getCode());
        relations();
        indexes();
        extendEntityClass();
        fields();
    }

    @Override
    public long id() {
        return Long.parseLong(boNode.getId());
    }

    //TODO
    @Override
    public void setType(int type) {

    }

    @Override
    public String code() {
        return boNode.getCode();
    }

    @Override
    public int ver() {
        Optional<Map<String, Object>> appOp = metadataEngine
                .get(__.has(ID_INDEX, boNode.getId()).toE(Direction.IN, HAS_BO.name())
                        .outV());

        if (appOp.isPresent()) {
            return VersionUtils.toVersionInt(appOp.get().get("version").toString());
        } else {
            return 0;
        }
    }

    @Override
    public String name() {
        return boNode.getName();
    }

    @Override
    public Collection<IRelation> relations() {
        if (relations == null) {
            List<Map<String, Object>> relationOp = metadataEngine
                    .getMulti(__.has(ID_INDEX, boNode.getId())
                            .outE(TO_MANY.name(), TO_ONE.name(), MANY_TO_MANY.name()));
            relations = relationOp.stream().map(x -> {
                BoRelationship boRelationship = new BoRelationship();
                boRelationship.setRelationType(x.get("type").toString());
                boRelationship.setProfile(x.get("profile").toString());
                boRelationship.setStrong((Boolean) x.get("isStrong"));
                boRelationship.setBoFieldId(x.get("boFieldId").toString());
                boRelationship.setJoinBoFieldId(x.get("joinBoFieldId").toString());
                boRelationship.setId(x.get("id").toString());
                boRelationship.setRelationCode(x.get("code").toString());
                boRelationship.setBoId(x.get("boId").toString());
                boRelationship.setJoinBoId(x.get("joinBoId").toString());
                return new LazyRelation(boRelationship);
            }).collect(Collectors.toList());
        }
        return relations;
    }

    //TODO
    @Override
    public Collection<IEntityClass> entityClasses() {
        return null;
    }

    //TODO
    @Override
    public Set<String> actions() {
        return null;
    }

    @Override
    public Collection<BoIndex> indexes() {
        String profile = StringUtils.isEmpty(ref.getProfile()) ? null : ref.getProfile();
        if (indexes == null) {
            List<Map<String, Object>> indexNodes = metadataEngine
                    .getMulti(__
                            .has(ID_INDEX, boNode.getId())
                            .has("profile", P.within(null, profile))
                            .outE(HAS_INDEX.name()).inV());
            indexes = indexNodes.stream().map(x -> {
                BoIndex boIndex = new BoIndex();
                boIndex.setUnique(Optional.ofNullable(x.get("isUnique")).map(p -> (boolean)p).orElse(false));
                boIndex.setPrimary(Optional.ofNullable(x.get("isPrimary")).map(p -> (boolean)p).orElse(false));
                boIndex.setFieldIds(Optional.ofNullable(x.get("fieldIds")).map(Object::toString).orElse(null));
                boIndex.setName(Optional.ofNullable(x.get("name")).map(Object::toString).orElse(null));
                boIndex.setProfile(profile);
                return boIndex;
            }).collect(Collectors.toList());
        }
        return indexes;
    }

    @Override
    public Collection<BoIndex> uniqueIndexes() {
        return indexes().stream()
                .filter(BoIndex::isUnique)
                .collect(Collectors.toList());
    }

    @Override
    public Collection<IEntityClass> childEntityClasses() {
        return null;
    }

    @Override
    public IEntityClass extendEntityClass() {
        String profile = StringUtils.isEmpty(ref.getProfile()) ? null : ref.getProfile();
        if (extendedClass == null) {
            Optional<Map<String, Object>> map = metadataEngine
                    .get(__.has(ID_INDEX, boNode.getId())
                            .has("profile", P.within(null, profile))
                            .outE(FATHER.name()).inV());
            if (map.isPresent()) {
                BoNode parentNode = new BoNode(map.get());
                extendedClass = new LazyEntityClass(metadataEngine, appCode(), parentNode);
            }
        }

        return extendedClass;
    }

    @Override
    public List<IEntityField> fields() {
        String profile = profile();
        if (fields == null) {
            List<Map<String, Object>> fieldNodes = metadataEngine
                    .getMulti(__
                            .has(ID_INDEX, boNode.getId())
                            .has("profile", P.within(null, profile))
                            .outE(HAS_FIELD.name()).inV());
            fields = fieldNodes.stream().map(x -> {
                BoField boField = new BoField();
                boField.from(x);
                return new LazyField(boField, metadataEngine);
            }).distinct().collect(Collectors.toList());

        }
        return fields;
    }

    @Override
    public List<IEntityField> selfFields() {
        return fields();
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public Collection<IEntityClass> family() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IEntityField> selfWithUnique() {
        List<IEntityField> all = new ArrayList<>(selfFields());

        for (IEntityField entityField : uniqueFieldCollection()) {
            if (!all.contains(entityField)) {
                all.add(entityField);
            }
        }

        return all;
    }

    @Override
    public Collection<IEntityField> uniqueFieldCollection() {
        Map<String, IEntityField> ef = new HashMap<>();
        for (BoIndex index : uniqueIndexes()) {
            String fieldIds = index.getFieldIds();
            String[] names = fieldIds.split(",");
            for (String name : names) {
                field(name).ifPresent(entityField -> ef.put(name, entityField));
            }
        }

        return new ArrayList<>(ef.values());
    }

    @Override
    public Collection<IEntityField> selfWithIndex() {
        List<IEntityField> all = new ArrayList<>(selfFields());

        Map<String, Function<Object, Object>> modifiers = new HashMap<>();
        modifiers.put("isDynamic", (result) -> false);

        for (IEntityField entityField : indexFieldCollection()) {
            if (!all.contains(entityField)) {
                IEntityField nonDynamic = ReturnValueModifierProxy.createProxy(entityField, modifiers, IEntityField.class);
                all.add(nonDynamic);
            }
        }

        return all;
    }

    @Override
    public Collection<IEntityField> indexFieldCollection() {
        Map<String, IEntityField> ef = new HashMap<>();
        for (BoIndex index : indexes()) {
            String fieldIds = index.getFieldIds();
            String[] names = fieldIds.split(",");
            for (String name : names) {
                field(name).ifPresent(entityField -> ef.put(name, entityField));
            }
        }

        return new ArrayList<>(ef.values());
    }

    @Override
    public Collection<IEntityField> withoutRelationFields() {
        return null;
    }

    @Override
    public Collection<IEntityField> selfWithoutRelationFields() {
        return null;
    }

    @Override
    public Optional<IEntityField> field(String name) {
        Optional<IEntityField> first = fields().stream().filter(x -> x.acceptName(name))
                .findFirst();
        if(!first.isPresent() && extendEntityClass() != null) {
            return extendEntityClass().field(name);
        } else {
            return first;
        }
    }

    @Override
    public Optional<IEntityField> field(long id) {
        return fields().stream().filter(x -> x.id() == id).findFirst();
    }

    @Override
    public boolean isAny() {
        return false;
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public String indexQueryTable() {
        return null;
    }

    /**
     * @returnMJX032901
     */
    @Override
    public EntityClassType type() {
        return null;
    }

    private boolean getMaster() {
        return false;
    }

    @Override
    public String masterQueryTable() {
        if (hasParent == null) {
            boolean present = metadataEngine
                    .get(__.has(ID_INDEX, boNode.getId()).outE(FATHER.name()).inV()).isPresent();
            hasParent = present;
        }

        if (hasParent) {
            return "oqs_".concat(ref.getAppCode()).concat("_").concat(code()).concat("_view");
        } else {
            return "oqs_".concat(ref.getAppCode()).concat("_").concat(code());
        }
    }

    @Override
    public String masterWriteTable() {
        return "oqs_".concat(ref.getAppCode()).concat("_").concat(code());
    }

    @Override
    public void resetChildEntityClass(Collection<IEntityClass> childEntityClasses) {

    }

    @Override
    public String appCode() {
        return ref.getAppCode();
    }

    @Override
    public String profile() {
        return ref.getProfile();
    }

    //TODO
    @Override
    public Optional<IEntityClass> father() {
        return Optional.empty();
    }

    @Override
    public int version() {
        return 0;
    }

    @Override
    public int level() {
        return 0;
    }

    @Override
    public EntityClassRef ref() {
        return ref;
    }

    @Override
    public IEntityClass root() {
        return null;
    }

    @Override
    public void onRefresh(Object payload) {

    }

    @Override
    public String toString() {
        return "LazyEntityClass{" +
                "boNode=" + boNode +
                ", ref=" + ref +
                ", extendedClass=" + extendedClass +
                ", hasParent=" + hasParent +
                ", relations=" + relations +
                ", fields=" + fields +
                ", indexes=" + indexes +
                '}';
    }
}
