package com.xforceplus.ultraman.metadata.entity.impl;

import com.xforceplus.metadata.schema.dsl.bo.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.BoField;
import com.xforceplus.ultraman.metadata.entity.CalculationType;
import com.xforceplus.ultraman.metadata.entity.FieldConfig;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.infra.Refreshable;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import static com.xforceplus.metadata.schema.rels.MetadataRelationType.HAS_TYPE;
import static com.xforceplus.metadata.schema.runtime.MetadataEngine.ID_INDEX;

public class LazyField implements IEntityField, Refreshable {

    private MetadataEngine engine;

    private BoField boField;

    private com.xforceplus.metadata.schema.typed.FieldType fieldType;

    private String dictId;

    private FieldConfig fieldConfig;

    public LazyField(BoField boField, MetadataEngine engine) {
        this.boField = boField;
        this.engine = engine;
        type();
        config();
    }

    @Override
    public long id() {
        return Long.parseLong(boField.getId());
    }

    @Override
    public String name() {
        return boField.getCode();
    }

    @Override
    public String cnName() {
        return boField.getName();
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public FieldType type() {
        if (fieldType == null) {
            Optional<Map<String, Object>> typeOp = engine.get(__.has(ID_INDEX, boField.getId())
                    .out(HAS_TYPE.name()));
            if (typeOp.isPresent()) {
                Map<String, Object> map = typeOp.get();
                com.xforceplus.metadata.schema.typed.FieldType fieldType = new com.xforceplus.metadata.schema.typed.FieldType();
                fieldType.from(map);
                this.fieldType = fieldType;
            } else {
                //is a generated field
                com.xforceplus.metadata.schema.typed.FieldType fieldType = new com.xforceplus.metadata.schema.typed.FieldType();
                fieldType.setValueType("Long");
                this.fieldType = fieldType;
            }
        }

        return fromFieldType(fieldType);
    }

    private FieldType fromFieldType(com.xforceplus.metadata.schema.typed.FieldType fieldType) {
        if (fieldType == null) {
            return FieldType.STRING;
        } else {
            String valueType = fieldType.getValueType();
            return FieldType.fromRawType(valueType);
        }
    }

    @Override
    public FieldConfig config() {
        if (fieldConfig == null) {
            FieldConfig config = new FieldConfig();
            this.fieldConfig = config.calculateType(CalculationType.STATIC.getSymbol())
                    .searchable(true)
                    .fieldSense(FieldConfig.FieldSense.NORMAL)
                    .isEditable(true)
                    .required(false)
                    .isSystem(false);
            if (boField.getCode().equals("id")) {
                fieldConfig.isSystem(true).identifie(true);
            }
        }
        return fieldConfig;
    }

    //TODO
    @Override
    public String dictId() {
        if (type() == FieldType.ENUM) {
            if (dictId == null) {
                dictId = fieldType.getDictId();
            }
            return dictId;
        } else {
            return null;
        }
    }

    //TODO
    @Override
    public String defaultValue() {
        return null;
    }

    //TODO
    @Override
    public IEntityField clone() {
        return new LazyField(this.boField, engine);
    }

    //TODO
    @Override
    public boolean isDynamic() {
        Boolean dynamic = boField.getDynamic();
        if (dynamic == null) {
           return boField.getCode().startsWith("dyn");
        }
        return boField.getDynamic();
    }

    //TODO
    @Override
    public CalculationType calculationType() {
        return null;
    }

    @Override
    public void onRefresh(Object payload) {

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LazyField lazyField = (LazyField) o;
        return Objects.equals(boField, lazyField.boField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(boField);
    }

    @Override
    public String toString() {
        return "LazyField{" +
                "boField=" + boField +
                ", fieldType=" + fieldType +
                ", dictId='" + dictId + '\'' +
                ", fieldConfig=" + fieldConfig +
                '}';
    }
}
