package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;

/**
 * 字符串值表示.
 *
 * @author wangzheng dongbin
 * @version 0.1 2020/2/18 20:54
 * @since 1.8
 */
public class StringValue extends AbstractValue<String> {

    public StringValue(IEntityField field, String value) {
        super(field, value);
    }

    public StringValue(IEntityField field, String value, Attachment attachment) {
        super(field, value, attachment);
    }

    public StringValue(IEntityField field, String value, String attachemnt) {
        super(field, value, attachemnt);
    }

    @Override
    String fromString(String value) {
        return value;
    }

    @Override
    public long valueToLong() {
        throw new UnsupportedOperationException("A string cannot be represented by a number.");
    }

    @Override
    public Object storageValue() {
        return getValue();
    }

    @Override
    protected IValue<String> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        Attachment attachment = this.getAttachment().copy();
        attachment.add(attachmentKey, attachmentValue);
        return new StringValue(newField, getValue(), attachment);
    }

    @Override
    protected IValue<String> doCopy(String value) {
        return new StringValue(getField(), value, getAttachment());
    }
}
