/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.engine.dsl;

import com.xforceplus.ultraman.metadata.engine.dsl.EntityClassResource;
import com.xforceplus.ultraman.metadata.engine.dsl.FieldsResource;
import com.xforceplus.ultraman.metadata.engine.dsl.MainFieldResource;
import com.xforceplus.ultraman.metadata.engine.dsl.RelatedEntityClassResource;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePart;
import com.xforceplus.ultraman.metadata.engine.dsl.RootResourcePart;
import com.xforceplus.ultraman.metadata.engine.dsl.SubEntityClassResource;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePath {
    private static Logger logger = LoggerFactory.getLogger(ResourcePath.class);
    private LinkedList<ResourcePart> parts = new LinkedList();

    public static ResourcePath parse(String path) {
        return new Parser().from(path);
    }

    public void setRoot(RootResourcePart root) {
        if (this.parts.isEmpty()) {
            this.parts.add(root);
        } else {
            logger.warn("Root only can be add once, discard {}", (Object)root);
        }
    }

    public Stream<ResourcePart> stream() {
        return this.parts.stream();
    }

    public Iterator<ResourcePart> iterator() {
        return this.parts.iterator();
    }

    public boolean push(ResourcePart resourcePart) {
        boolean canAdd = this.parts.getLast().nextType().stream().anyMatch(x -> x == resourcePart.type());
        if (canAdd) {
            this.parts.add(resourcePart);
            return true;
        }
        logger.warn("Cannot add part {}, last one is {}", (Object)resourcePart, (Object)this.parts.getLast());
        return false;
    }

    public boolean isMultiResource() {
        return this.parts.getLast().isMulti();
    }

    public String toString() {
        return "ResourcePath{parts=" + this.parts + '}';
    }

    public static class Parser {
        public static final String ROOT = "@";
        public static final String PART_DEL = "#";
        public static final String REF_PREFIX = "_";
        public static final String SUB = "/";
        public static final String STAR = "*";
        public static final String REF_DEL = ".";
        public static final String REG_REF_DEL = "\\.";

        public ResourcePath from(String path) {
            String[] parts = path.split(PART_DEL);
            ResourcePath resourcePath = new ResourcePath();
            boolean hasRoot = false;
            for (String part : parts) {
                boolean success;
                String rawPart = part;
                if (rawPart.startsWith(ROOT)) {
                    if (!hasRoot) {
                        String entityCode = rawPart = rawPart.substring(1);
                        resourcePath.setRoot(new EntityClassResource(entityCode));
                        hasRoot = true;
                        continue;
                    }
                    logger.warn("Can only have one root, discard {}", (Object)rawPart);
                    continue;
                }
                if (part.startsWith(REF_PREFIX)) {
                    boolean success2;
                    boolean success3;
                    String entityCode;
                    rawPart = rawPart.substring(1);
                    String relatedCode = null;
                    if (rawPart.contains(REF_DEL)) {
                        String[] fieldPart = rawPart.split(REG_REF_DEL, 2);
                        entityCode = fieldPart[0];
                        relatedCode = fieldPart[1];
                    } else {
                        entityCode = rawPart;
                    }
                    if (!StringUtils.isEmpty((CharSequence)entityCode) && !(success3 = resourcePath.push(new RelatedEntityClassResource(entityCode)))) break;
                    String nextPart = relatedCode;
                    if (StringUtils.isEmpty(nextPart)) continue;
                    if (nextPart.contains(SUB)) {
                        String[] subFields = nextPart.split(SUB);
                        String subEntityClass = subFields[0];
                        nextPart = subFields[1];
                        boolean success4 = resourcePath.push(new SubEntityClassResource(subEntityClass));
                        if (!success4) break;
                    }
                    if (!(nextPart.equals(STAR) ? !(success2 = resourcePath.push(FieldsResource.ins)) : !(success2 = resourcePath.push(new MainFieldResource(nextPart))))) continue;
                    break;
                }
                if (rawPart.contains(SUB)) {
                    String[] subFields = rawPart.split(SUB);
                    String subEntityClass = subFields[0];
                    rawPart = subFields[1];
                    boolean success5 = resourcePath.push(new SubEntityClassResource(subEntityClass));
                    if (!success5) break;
                }
                if (rawPart.equals(STAR) ? !(success = resourcePath.push(FieldsResource.ins)) : !(success = resourcePath.push(new MainFieldResource(rawPart)))) break;
            }
            return resourcePath;
        }
    }

    static enum ResourceType {
        ENTITY_CLASS,
        ENTITY_REF,
        SUB_ENTITY,
        FIELDS;

    }
}

