/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity.legacy.impl;

import com.xforceplus.ultraman.metadata.entity.CalculationType;
import com.xforceplus.ultraman.metadata.entity.FieldConfig;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.infra.Wrapped;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AliasField
implements IEntityField,
Wrapped<IEntityField>,
Serializable {
    private final IEntityField originField;
    private Set<String> alias = new HashSet<String>();

    public AliasField(IEntityField originField) {
        this.originField = originField;
        this.alias.add(originField.name());
    }

    public void addName(String name) {
        this.alias.add(name);
    }

    @Override
    public long id() {
        return this.originField.id();
    }

    @Override
    public String name() {
        return String.join((CharSequence)",", this.alias);
    }

    public String firstName() {
        return this.alias.stream().findFirst().orElse("");
    }

    public String filterName(String name) {
        return this.alias.stream().filter(x -> x.equals(name)).findFirst().orElse("");
    }

    @Override
    public String cnName() {
        return this.originField.cnName();
    }

    @Override
    public FieldType type() {
        return this.originField.type();
    }

    @Override
    public FieldConfig config() {
        return this.originField.config();
    }

    @Override
    public String dictId() {
        return this.originField.dictId();
    }

    @Override
    public String defaultValue() {
        return this.originField.defaultValue();
    }

    @Override
    public IEntityField clone() {
        AliasField field = new AliasField(this.originField.clone());
        this.alias.forEach(field::addName);
        return field;
    }

    @Override
    public boolean isDynamic() {
        return this.originField.isDynamic();
    }

    @Override
    public CalculationType calculationType() {
        return this.originField.calculationType();
    }

    public String toString() {
        return "AliasField{id=" + this.id() + ", alias=" + this.alias + ", originField=" + this.originField + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasField field = (AliasField)o;
        return Objects.equals(this.originField, field.originField) && Objects.equals(this.alias, field.alias);
    }

    public int hashCode() {
        return Objects.hash(this.originField, this.alias);
    }

    public IEntityField getOriginObject() {
        return this.originField;
    }
}

