package com.xforceplus.ultraman.metadata.entity.legacy.impl;

import com.xforceplus.metadata.schema.typed.BoIndex;
import com.xforceplus.ultraman.metadata.entity.*;

import java.util.*;

/**
 * 这是一个特殊的 EntityClass,类似于 JAVA 中 Object.class.
 * 可以表示任意的类型,但其中所有的属性都无意义.
 *
 * @author dongbin
 * @version 0.1 2020/3/1 23:46
 * @since 1.8
 */
public class AnyEntityClass implements IEntityClass {

    private static final IEntityClass INSTANCE = new AnyEntityClass();

    /**
     * 获取实例.
     * @return 实例.
     */
    public static IEntityClass getInstance() {
        return INSTANCE;
    }

    @Override
    public long id() {
        return -1;
    }

    @Override
    public void setType(int type) {

    }

    @Override
    public String code() {
        return "";
    }

    @Override
    public int ver() {
        return 0;
    }

    @Override
    public String name() {
        return "";
    }

    @Override
    public Collection<IRelation> relations() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IEntityClass> entityClasses() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> actions() {
        return Collections.emptySet();
    }

    @Override
    public Collection<BoIndex> indexes() {
        return null;
    }

    @Override
    public Collection<BoIndex> uniqueIndexes() {
        return null;
    }

    @Override
    public Collection<IEntityClass> childEntityClasses() {
        return null;
    }

    @Override
    public IEntityClass extendEntityClass() {
        return null;
    }

    @Override
    public List<IEntityField> fields() {
        return Collections.emptyList();
    }

    @Override
    public List<IEntityField> selfFields() {
        return null;
    }

    @Override
    public Collection<IEntityClass> family() {
        return null;
    }

    @Override
    public Collection<IEntityField> selfWithUnique() {
        return null;
    }

    @Override
    public Collection<IEntityField> uniqueFieldCollection() {
        return null;
    }

    @Override
    public Collection<IEntityField> selfWithIndex() {
        return null;
    }

    @Override
    public Collection<IEntityField> indexFieldCollection() {
        return null;
    }

    @Override
    public Collection<IEntityField> withoutRelationFields() {
        return null;
    }

    @Override
    public Collection<IEntityField> selfWithoutRelationFields() {
        return null;
    }

    @Override
    public Optional<IEntityField> field(String name) {
        return Optional.empty();
    }

    @Override
    public Optional<IEntityField> field(long id) {
        return Optional.empty();
    }

    @Override
    public boolean isAny() {
        return true;
    }

    @Override
    public String indexQueryTable() {
        return null;
    }

    @Override
    public EntityClassType type() {
        return null;
    }

    @Override
    public String masterQueryTable() {
        return code();
    }

    @Override
    public String masterWriteTable() {
        return null;
    }

    @Override
    public void resetChildEntityClass(Collection<IEntityClass> childEntityClasses) {

    }

    @Override
    public String appCode() {
        return null;
    }

    @Override
    public String profile() {
        return null;
    }

    @Override
    public String realProfile() {
        return null;
    }

    @Override
    public Optional<IEntityClass> father() {
        return Optional.empty();
    }

    @Override
    public int version() {
        return 0;
    }

    @Override
    public int level() {
        return 0;
    }

    @Override
    public EntityClassRef ref() {
        return null;
    }

    @Override
    public IEntityClass root() {
        return null;
    }
}
