/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ultraman.metadata.entity.calculation.AbstractCalculation;
import com.xforceplus.ultraman.metadata.entity.calculation.StaticCalculation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.Formula;
import java.io.Serializable;
import java.util.Objects;
import java.util.StringJoiner;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FieldConfig
implements Serializable {
    public static final FieldConfig DEFAULT_CONFIG = Builder.anFieldConfig().build();
    @JsonProperty(value="searchable")
    private boolean searchable = false;
    @JsonProperty(value="identifie")
    private boolean identifie = false;
    @JsonProperty(value="required")
    private boolean required = false;
    @JsonProperty(value="crossSearch")
    private boolean crossSearch = false;
    @JsonProperty(value="splittable")
    private boolean splittable = false;
    @JsonProperty(value="len")
    private int len = 19;
    @JsonProperty(value="precision")
    private int precision = 6;
    @JsonProperty(value="scale")
    private int scale = 0;
    @JsonProperty(value="jdbcType")
    private int jdbcType = 0;
    @JsonProperty(value="max")
    @Deprecated
    private long max = Long.MAX_VALUE;
    @JsonProperty(value="min")
    private long min = Long.MIN_VALUE;
    @JsonProperty(value="fieldSense")
    private FieldSense fieldSense = FieldSense.NORMAL;
    @JsonProperty(value="validateRegexString")
    private String validateRegexString = "";
    @JsonProperty(value="delimiter")
    private String delimiter = "";
    @JsonProperty(value="displayType")
    private String displayType = "";
    @JsonProperty(value="fuzzyType")
    private FuzzyType fuzzyType = FuzzyType.NOT;
    @JsonProperty(value="wildcardMinWidth")
    private int wildcardMinWidth = 3;
    @JsonProperty(value="wildcardMaxWidth")
    private int wildcardMaxWidth = 6;
    @JsonProperty(value="uniqueName")
    private String uniqueName = "";
    @JsonProperty(value="calculation")
    private AbstractCalculation calculation;
    private Formula formula;
    private boolean isSystem;
    private int calculateType;
    private boolean isEditable;

    public FieldConfig isEditable(boolean isEditable) {
        this.isEditable = isEditable;
        return this;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public FieldConfig isSystem(boolean isSystem) {
        this.isSystem = isSystem;
        return this;
    }

    public FieldConfig uniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public String uniqueName() {
        return this.uniqueName;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public FieldConfig formula(Formula formula) {
        this.formula = formula;
        return this;
    }

    public FieldConfig calculateType(Integer calculateType) {
        this.calculateType = calculateType;
        return this;
    }

    @Deprecated
    public static FieldConfig build() {
        return new FieldConfig();
    }

    public FieldConfig precision(int precision) {
        this.precision = precision;
        return this;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public FieldConfig searchable(boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    @Deprecated
    public FieldConfig max(long max) {
        this.max = max;
        return this;
    }

    public AbstractCalculation getCalculation() {
        if (this.calculation == null) {
            return StaticCalculation.Builder.anStaticCalculation().build();
        }
        return this.calculation;
    }

    public AbstractCalculation resetCalculation(AbstractCalculation calculation) {
        this.calculation = calculation;
        return this.calculation;
    }

    @Deprecated
    public FieldConfig min(long min) {
        this.min = min;
        return this;
    }

    public FieldConfig identifie(boolean identifie) {
        this.identifie = identifie;
        return this;
    }

    public FieldConfig fuzzyType(FuzzyType type) {
        this.fuzzyType = type;
        return this;
    }

    public boolean isIdentifie() {
        return this.identifie;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isCrossSearch() {
        return this.crossSearch;
    }

    public boolean indexAttachment() {
        if (null == this.calculation) {
            return true;
        }
        return this.calculation.indexAttachment();
    }

    @Deprecated
    public long getMax() {
        return this.max;
    }

    @Deprecated
    public long getMin() {
        return this.min;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public FieldConfig displayType(String displayType) {
        this.displayType = displayType;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public FieldConfig required(boolean required) {
        this.required = required;
        return this;
    }

    public FieldSense getFieldSense() {
        return this.fieldSense;
    }

    public FieldConfig fieldSense(FieldSense fieldSense) {
        this.fieldSense = fieldSense;
        return this;
    }

    public String getValidateRegexString() {
        return this.validateRegexString;
    }

    public FieldConfig validateRegexString(String validateRegexString) {
        this.validateRegexString = validateRegexString;
        return this;
    }

    public boolean isSplittable() {
        return this.splittable;
    }

    public FieldConfig splittable(boolean splittable) {
        this.splittable = splittable;
        return this;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public FieldConfig delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public FuzzyType getFuzzyType() {
        return this.fuzzyType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getWildcardMinWidth() {
        return this.wildcardMinWidth;
    }

    public int getWildcardMaxWidth() {
        return this.wildcardMaxWidth;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public int getLen() {
        return this.len;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(int jdbcType) {
        this.jdbcType = jdbcType;
    }

    public FieldConfig clone() {
        return Builder.anFieldConfig().withDelimiter(this.getDelimiter()).withDisplayType(this.getDisplayType()).withFieldSense(this.getFieldSense()).withFuzzyType(this.getFuzzyType()).withIdentifie(this.isIdentifie()).withMax(this.getMax()).withMin(this.getMin()).withPrecision(this.getPrecision()).withRequired(this.isRequired()).withSearchable(this.isSearchable()).withSplittable(this.isSplittable()).withUniqueName(this.getUniqueName()).withValidateRegexString(this.getValidateRegexString()).withWildcardMaxWidth(this.getWildcardMaxWidth()).withWildcardMinWidth(this.getWildcardMinWidth()).withCrossSearch(this.isCrossSearch()).withLen(this.getLen()).withScale(this.scale()).withCalculation(this.getCalculation().clone()).withJdbcType(this.getJdbcType()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldConfig)) {
            return false;
        }
        FieldConfig that = (FieldConfig)o;
        return this.isSearchable() == that.isSearchable() && this.precision() == that.precision() && this.scale() == that.scale() && this.isIdentifie() == that.isIdentifie() && this.isRequired() == that.isRequired() && this.isSplittable() == that.isSplittable() && this.getWildcardMinWidth() == that.getWildcardMinWidth() && this.getWildcardMaxWidth() == that.getWildcardMaxWidth() && this.getFieldSense() == that.getFieldSense() && Objects.equals(this.getValidateRegexString(), that.getValidateRegexString()) && Objects.equals(this.getDelimiter(), that.getDelimiter()) && Objects.equals(this.getDisplayType(), that.getDisplayType()) && this.getFuzzyType() == that.getFuzzyType() && this.getLen() == that.getLen();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isSearchable(), this.getLen(), this.precision(), this.isIdentifie(), this.isRequired(), this.getFieldSense(), this.getValidateRegexString(), this.isSplittable(), this.getDelimiter(), this.getDisplayType()});
    }

    public String toString() {
        return new StringJoiner(", ", FieldConfig.class.getSimpleName() + "[", "]").add("searchable=" + this.searchable).add("max=" + this.max).add("min=" + this.min).add("len=" + this.len).add("precision=" + this.precision).add("scale=" + this.scale).add("identifie=" + this.identifie).add("required=" + this.required).add("fieldSense=" + (Object)((Object)this.fieldSense)).add("crossSearch=" + this.crossSearch).add("validateRegexString='" + this.validateRegexString + "'").add("splittable=" + this.splittable).add("delimiter='" + this.delimiter + "'").add("displayType='" + this.displayType + "'").add("fuzzyType=" + (Object)((Object)this.fuzzyType)).add("wildcardMinWidth=" + this.wildcardMinWidth).add("wildcardMaxWidth=" + this.wildcardMaxWidth).add("uniqueName='" + this.uniqueName + "'").add("calculation=" + this.calculation).add("jdbcType=" + this.jdbcType).toString();
    }

    public static final class Builder {
        private boolean searchable = false;
        private boolean crossSearch = false;
        private boolean identifie = false;
        private boolean required = false;
        private boolean splittable = false;
        private int wildcardMinWidth = 3;
        private int wildcardMaxWidth = 6;
        private int len = 19;
        private int precision = 0;
        private int scale = 0;
        private int jdbcType = 0;
        private long max = Long.MAX_VALUE;
        private long min = Long.MIN_VALUE;
        private String validateRegexString = "";
        private String delimiter = "";
        private String displayType = "";
        private String uniqueName = "";
        private FieldSense fieldSense = FieldSense.NORMAL;
        private FuzzyType fuzzyType = FuzzyType.NOT;
        private AbstractCalculation calculation = StaticCalculation.Builder.anStaticCalculation().build();

        private Builder() {
        }

        public static Builder anFieldConfig() {
            return new Builder();
        }

        public Builder withSearchable(boolean searchable) {
            this.searchable = searchable;
            return this;
        }

        public Builder withCrossSearch(boolean crossSearch) {
            this.crossSearch = crossSearch;
            return this;
        }

        @Deprecated
        public Builder withMax(long max) {
            return this;
        }

        @Deprecated
        public Builder withMin(long min) {
            return this;
        }

        public Builder withLen(int len) {
            this.len = len;
            return this;
        }

        public Builder withPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder withScale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder withIdentifie(boolean identifie) {
            this.identifie = identifie;
            return this;
        }

        public Builder withRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder withFieldSense(FieldSense fieldSense) {
            this.fieldSense = fieldSense;
            return this;
        }

        public Builder withValidateRegexString(String validateRegexString) {
            this.validateRegexString = validateRegexString;
            return this;
        }

        public Builder withSplittable(boolean splittable) {
            this.splittable = splittable;
            return this;
        }

        public Builder withDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder withDisplayType(String displayType) {
            this.displayType = displayType;
            return this;
        }

        public Builder withFuzzyType(FuzzyType fuzzyType) {
            this.fuzzyType = fuzzyType;
            return this;
        }

        public Builder withWildcardMinWidth(int wildcardMinWidth) {
            this.wildcardMinWidth = wildcardMinWidth;
            return this;
        }

        public Builder withWildcardMaxWidth(int wildcardMaxWidth) {
            this.wildcardMaxWidth = wildcardMaxWidth;
            return this;
        }

        public Builder withUniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            return this;
        }

        public Builder withCalculation(AbstractCalculation calculation) {
            this.calculation = calculation;
            return this;
        }

        public Builder withJdbcType(int jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        public FieldConfig build() {
            FieldConfig fieldConfig = new FieldConfig();
            fieldConfig.validateRegexString = this.validateRegexString;
            fieldConfig.len = this.len;
            fieldConfig.min = this.min;
            fieldConfig.max = this.max;
            fieldConfig.fieldSense = this.fieldSense;
            fieldConfig.precision = this.precision;
            fieldConfig.scale = this.scale;
            fieldConfig.delimiter = this.delimiter;
            fieldConfig.identifie = this.identifie;
            fieldConfig.splittable = this.splittable;
            fieldConfig.fuzzyType = this.fuzzyType;
            fieldConfig.jdbcType = this.jdbcType;
            fieldConfig.searchable = this.searchable;
            fieldConfig.crossSearch = this.crossSearch;
            fieldConfig.wildcardMinWidth = this.wildcardMinWidth;
            fieldConfig.wildcardMaxWidth = this.wildcardMaxWidth;
            fieldConfig.required = this.required;
            fieldConfig.displayType = this.displayType;
            fieldConfig.uniqueName = this.uniqueName;
            fieldConfig.calculation = null == this.calculation ? StaticCalculation.Builder.anStaticCalculation().build() : this.calculation;
            return fieldConfig;
        }
    }

    public static enum FuzzyType {
        UNKNOWN(0),
        NOT(1),
        WILDCARD(2),
        SEGMENTATION(3);

        private final int symbol;

        private FuzzyType(int symbol) {
            this.symbol = symbol;
        }

        public int getSymbol() {
            return this.symbol;
        }

        public static FuzzyType getInstance(int symbol) {
            for (FuzzyType type : FuzzyType.values()) {
                if (type.getSymbol() != symbol) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static enum FieldSense {
        UNKNOWN(0),
        NORMAL(1),
        TENANT_ID(2),
        TENANT_CODE(3),
        CREATE_TIME(4),
        UPDATE_TIME(5),
        CREATE_USER_ID(6),
        UPDATE_USER_ID(7),
        CREATE_USER_NAME(8),
        UPDATE_USER_NAME(9),
        DELETE_FLAG(10);

        private final int symbol;

        private FieldSense(int symbol) {
            this.symbol = symbol;
        }

        public int getSymbol() {
            return this.symbol;
        }

        public static FieldSense getInstance(int symbol) {
            for (FieldSense sense : FieldSense.values()) {
                if (sense.getSymbol() != symbol) continue;
                return sense;
            }
            return UNKNOWN;
        }
    }
}

