package com.xforceplus.ultraman.metadata.helper.converter;

import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.EntityField;
import com.xforceplus.ultraman.metadata.values.DateTimeValue;
import com.xforceplus.ultraman.metadata.values.IValue;
import org.apache.commons.beanutils.converters.AbstractConverter;

import java.time.LocalDateTime;
import java.util.Optional;

/**
 * localdatetime converter
 */
public class LocalDateTimeConverter extends AbstractConverter {

    IEntityField dummy = new EntityField(1L, "", FieldType.DATETIME);

    @Override
    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {

        final Class<?> sourceType = value.getClass();

        // Handle java.sql.Timestamp
        if (value instanceof LocalDateTime) {
            return (T)value;
        } else  {
            String valStr = value.toString();
            if(FieldType.DATETIME.canParseFrom(valStr)){

                Optional<IValue> iValue = FieldType.DATETIME.toTypedValue(dummy, valStr);

                if(iValue.isPresent()){
                    return (T)((DateTimeValue)iValue.get()).getValue();
                }
            }
        }

        return null;
    }

    @Override
    protected Class<?> getDefaultType() {
        return LocalDateTime.class;
    }

    @Override
    protected String convertToString(Object value) throws Throwable {
        if(value instanceof LocalDateTime) {
            return Long.toString(new DateTimeValue(null, (LocalDateTime)value).valueToLong());
        }

        return super.convertToString(value);
    }

    @Override
    public <T> T convert(Class<T> type, Object value) {
        return super.convert(type, value);
    }
}
