/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.entity.impl;

import com.xforceplus.metadata.schema.dsl.bo.__;
import com.xforceplus.metadata.schema.dsl.utils.MatcherHelper;
import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.BoField;
import com.xforceplus.metadata.schema.typed.BoIndex;
import com.xforceplus.metadata.schema.typed.BoNode;
import com.xforceplus.metadata.schema.typed.BoRelationship;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.EntityClassType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.impl.LazyField;
import com.xforceplus.ultraman.metadata.entity.impl.LazyRelation;
import com.xforceplus.ultraman.metadata.helper.VersionUtils;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.utils.ReturnValueModifierProxy;
import com.xforceplus.ultraman.sdk.infra.utils.TenantUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class LazyEntityClass
implements IEntityClass,
Refreshable {
    private MetadataEngine metadataEngine;
    private BoNode boNode;
    private EntityClassRef ref;
    private IEntityClass extendedClass = null;
    private Boolean hasParent = null;
    private List<IRelation> relations;
    private List<IEntityField> fields;
    private List<BoIndex> indexes = null;
    private static final String PROFILED_VIEW = "oqs_%s_%s_%s_view";
    private static final String PARENT_VIEW = "oqs_%s_%s_view";
    private static final String GENERAL_VIEW = "oqs_%s_%s";
    private boolean inited = false;

    public LazyEntityClass(MetadataEngine metadataEngine, String appCode, BoNode boNode) {
        this.metadataEngine = metadataEngine;
        this.boNode = boNode;
        this.ref = new EntityClassRef(Long.parseLong(boNode.getId()), appCode, boNode.getCode());
        this.relations();
        this.indexes();
        this.extendEntityClass();
        this.fields();
        this.masterQueryTable();
        this.inited = true;
    }

    public LazyEntityClass(MetadataEngine metadataEngine, String appCode, BoNode boNode, String profile) {
        this.metadataEngine = metadataEngine;
        this.boNode = boNode;
        this.ref = new EntityClassRef(Long.parseLong(boNode.getId()), appCode, boNode.getCode(), profile);
        this.relations();
        this.indexes();
        this.extendEntityClass();
        this.fields();
        this.masterQueryTable();
        this.inited = true;
    }

    @Override
    public long id() {
        return Long.parseLong(this.boNode.getId());
    }

    @Override
    public void setType(int type) {
    }

    @Override
    public String code() {
        return this.boNode.getCode();
    }

    @Override
    public int ver() {
        Optional appOp = this.metadataEngine.get((GraphTraversal)__.has((String)"_id", (Object)this.boNode.getId()).toE(Direction.IN, new String[]{MetadataRelationType.HAS_BO.name()}).outV());
        if (appOp.isPresent()) {
            return VersionUtils.toVersionInt(((Map)appOp.get()).get("version").toString());
        }
        return 0;
    }

    @Override
    public String name() {
        return this.boNode.getName();
    }

    @Override
    public Collection<IRelation> relations() {
        if (this.relations == null && !this.inited) {
            List relationOp = this.metadataEngine.getMulti((GraphTraversal)__.has((String)"_id", (Object)this.boNode.getId()).outE(new String[]{MetadataRelationType.TO_MANY.name(), MetadataRelationType.TO_ONE.name(), MetadataRelationType.MANY_TO_MANY.name()}));
            this.relations = relationOp.stream().map(x -> {
                BoRelationship boRelationship = new BoRelationship();
                boRelationship.setRelationType(x.get("type").toString());
                boRelationship.setProfile(x.get("profile").toString());
                boRelationship.setStrong(((Boolean)x.get("isStrong")).booleanValue());
                boRelationship.setBoFieldId(x.get("boFieldId").toString());
                boRelationship.setJoinBoFieldId(x.get("joinBoFieldId").toString());
                boRelationship.setId(x.get("id").toString());
                boRelationship.setRelationCode(x.get("code").toString());
                boRelationship.setBoId(x.get("boId").toString());
                boRelationship.setJoinBoId(x.get("joinBoId").toString());
                return new LazyRelation(boRelationship);
            }).collect(Collectors.toList());
        }
        return this.relations;
    }

    @Override
    public Collection<IEntityClass> getEntityTables() {
        return new ArrayList<IEntityClass>();
    }

    @Override
    public Collection<IEntityClass> entityClasses() {
        return null;
    }

    @Override
    public Set<String> actions() {
        return null;
    }

    @Override
    public Collection<BoIndex> indexes() {
        String profile;
        String string = profile = StringUtils.isEmpty((CharSequence)this.ref.getProfile()) ? null : this.ref.getProfile();
        if (this.indexes == null && !this.inited) {
            List indexNodes = this.metadataEngine.getMulti((GraphTraversal)__.has((String)"_id", (Object)this.boNode.getId()).has("profile", P.within((Object[])new String[]{null, profile})).outE(new String[]{MetadataRelationType.HAS_INDEX.name()}).inV());
            this.indexes = indexNodes.stream().map(x -> {
                BoIndex boIndex = new BoIndex();
                boIndex.setUnique(Optional.ofNullable(x.get("isUnique")).map(p -> (boolean)((Boolean)p)).orElse(false).booleanValue());
                boIndex.setPrimary(Optional.ofNullable(x.get("isPrimary")).map(p -> (boolean)((Boolean)p)).orElse(false).booleanValue());
                boIndex.setFieldIds((String)Optional.ofNullable(x.get("fieldIds")).map(Object::toString).orElse(null));
                boIndex.setName((String)Optional.ofNullable(x.get("name")).map(Object::toString).orElse(null));
                boIndex.setProfile(profile);
                return boIndex;
            }).collect(Collectors.toList());
        }
        return this.indexes;
    }

    @Override
    public Collection<BoIndex> uniqueIndexes() {
        return this.indexes().stream().filter(BoIndex::isUnique).collect(Collectors.toList());
    }

    @Override
    public Collection<IEntityClass> childEntityClasses() {
        return null;
    }

    @Override
    public IEntityClass extendEntityClass() {
        Optional map;
        String profile;
        String string = profile = StringUtils.isEmpty((CharSequence)this.ref.getProfile()) ? null : this.ref.getProfile();
        if (this.extendedClass == null && !this.inited && (map = this.metadataEngine.get((GraphTraversal)__.has((String)"_id", (Object)this.boNode.getId()).where((Traversal)org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.__.has((String)"profile", (P)MatcherHelper.caseInsensitiveEq((String)profile)).or(new Traversal[0]).hasNot("profile")).outE(new String[]{MetadataRelationType.FATHER.name()}).inV())).isPresent()) {
            BoNode parentNode = new BoNode((Map)map.get());
            this.extendedClass = new LazyEntityClass(this.metadataEngine, this.appCode(), parentNode, this.realProfile());
        }
        return this.extendedClass;
    }

    public List<IEntityField> fields() {
        String profile;
        String string = profile = StringUtils.isEmpty((CharSequence)this.ref.getProfile()) ? null : this.ref.getProfile();
        if (this.fields == null && !this.inited) {
            List fieldNodes = this.metadataEngine.getMulti((GraphTraversal)__.has((String)"_id", (Object)this.id()).has("profile", (P)MatcherHelper.caseInsensitiveEq((String)profile)).fold().coalesce(new Traversal[]{__.unfold(), __.V((Object[])new Object[0]).has("_id", (Object)this.id()).hasNot("profile")}).outE(new String[]{MetadataRelationType.HAS_FIELD.name()}).inV().has("boId", (Object)this.boNode.getId()));
            this.fields = fieldNodes.stream().map(x -> {
                BoField boField = new BoField();
                boField.from(x);
                return new LazyField(boField, this.metadataEngine);
            }).distinct().collect(Collectors.toList());
        }
        return this.fields;
    }

    public List<IEntityField> selfFields() {
        return this.fields();
    }

    @Override
    public Collection<IEntityClass> family() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IEntityField> selfWithUnique() {
        ArrayList<IEntityField> all = new ArrayList<IEntityField>(this.selfFields());
        for (IEntityField entityField : this.uniqueFieldCollection()) {
            if (all.contains(entityField)) continue;
            all.add(entityField);
        }
        return all;
    }

    @Override
    public Collection<IEntityField> uniqueFieldCollection() {
        HashMap ef = new HashMap();
        for (BoIndex index : this.uniqueIndexes()) {
            String[] names;
            String fieldIds = index.getFieldIds();
            for (String name : names = fieldIds.split(",")) {
                this.field(name).ifPresent(entityField -> ef.put(name, entityField));
            }
        }
        return new ArrayList<IEntityField>(ef.values());
    }

    @Override
    public Collection<IEntityField> selfWithIndex() {
        ArrayList<IEntityField> all = new ArrayList<IEntityField>(this.selfFields());
        HashMap<String, Function<Object, Object>> modifiers = new HashMap<String, Function<Object, Object>>();
        modifiers.put("isDynamic", result -> false);
        for (IEntityField entityField : this.indexFieldCollection()) {
            if (all.contains(entityField)) continue;
            IEntityField nonDynamic = (IEntityField)ReturnValueModifierProxy.createProxy((Object)entityField, modifiers, (Class[])new Class[]{IEntityField.class});
            all.add(nonDynamic);
        }
        return all;
    }

    @Override
    public Collection<IEntityField> indexFieldCollection() {
        HashMap ef = new HashMap();
        for (BoIndex index : this.indexes()) {
            String[] names;
            String fieldIds = index.getFieldIds();
            for (String name : names = fieldIds.split(",")) {
                this.field(name).ifPresent(entityField -> ef.put(name, entityField));
            }
        }
        return new ArrayList<IEntityField>(ef.values());
    }

    @Override
    public Collection<IEntityField> withoutRelationFields() {
        return null;
    }

    @Override
    public Collection<IEntityField> selfWithoutRelationFields() {
        return null;
    }

    @Override
    public Optional<IEntityField> field(String name) {
        Optional<IEntityField> first = this.fields().stream().filter(x -> x.acceptName(name)).findFirst();
        if (!first.isPresent() && this.extendEntityClass() != null) {
            return this.extendEntityClass().field(name);
        }
        return first;
    }

    @Override
    public Optional<IEntityField> field(long id) {
        return this.fields().stream().filter(x -> x.id() == id).findFirst();
    }

    @Override
    public boolean isAny() {
        return false;
    }

    @Override
    public String indexQueryTable() {
        return null;
    }

    @Override
    public EntityClassType type() {
        return null;
    }

    private boolean getMaster() {
        return false;
    }

    @Override
    public String masterQueryTable() {
        if (!StringUtils.isEmpty((CharSequence)this.realProfile())) {
            return String.format(PROFILED_VIEW, this.ref.getAppCode(), this.ref.getCode(), TenantUtil.convertSpecialSymbolToUnderscore((String)this.realProfile()));
        }
        if (this.hasParent == null && !this.inited) {
            boolean present = this.metadataEngine.get((GraphTraversal)__.has((String)"_id", (Object)this.boNode.getId()).outE(new String[]{MetadataRelationType.FATHER.name()}).inV()).isPresent();
            this.hasParent = present;
        }
        if (this.hasParent.booleanValue()) {
            return String.format(PARENT_VIEW, this.ref.getAppCode(), this.code());
        }
        return String.format(GENERAL_VIEW, this.ref.getAppCode(), this.code());
    }

    @Override
    public String masterWriteTable(boolean withProfile) {
        if (!StringUtils.isEmpty((CharSequence)this.realProfile()) && withProfile) {
            return "oqs_".concat(this.ref.getAppCode()).concat("_").concat(this.code()).concat("_").concat(TenantUtil.convertSpecialSymbolToUnderscore((String)this.realProfile()));
        }
        return "oqs_".concat(this.ref.getAppCode()).concat("_").concat(this.code());
    }

    @Override
    public void resetChildEntityClass(Collection<IEntityClass> childEntityClasses) {
    }

    @Override
    public String appCode() {
        return this.ref.getAppCode();
    }

    @Override
    public String profile() {
        return this.ref.getProfile();
    }

    @Override
    public String realProfile() {
        return this.boNode.getProfile();
    }

    @Override
    public Optional<IEntityClass> father() {
        return Optional.empty();
    }

    @Override
    public int version() {
        return 0;
    }

    @Override
    public int level() {
        return 0;
    }

    @Override
    public EntityClassRef ref() {
        return this.ref;
    }

    @Override
    public IEntityClass root() {
        return null;
    }

    public void onRefresh(Object payload) {
    }

    public String toString() {
        return "LazyEntityClass{boNode=" + this.boNode + ", ref=" + this.ref + ", extendedClass=" + this.extendedClass + ", hasParent=" + this.hasParent + ", relations=" + this.relations + ", fields=" + this.fields + ", indexes=" + this.indexes + '}';
    }
}

