package com.xforceplus.ultraman.metadata.engine.impl;

import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.ultraman.metadata.domain.record.GeneralRecord;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePath;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.xforceplus.metadata.schema.dsl.metadata.__.has;
import static com.xforceplus.metadata.schema.rels.MetadataRelationType.FATHER;
import static com.xforceplus.metadata.schema.rels.MetadataRelationType.SON;
import static com.xforceplus.metadata.schema.runtime.MetadataEngine.ID_INDEX;

/**
 * TODO register on the event
 * cache  this
 * group view of a EntityClass
 */
public class EntityClassGroupImpl implements EntityClassGroup, Refreshable {

    private MetadataEngine metadataEngine;

    private EntityClassEngine classEngine;

    private IEntityClass mainEntityClass;

    private Collection<IEntityClass> fatherEntityClasses = null;

    private Collection<IEntityClass> childrenEntityClasses = null;

    private Collection<String> relatedEntityClassCodes = null;

    private String profile;

    public EntityClassGroupImpl(EntityClassEngine classEngine, MetadataEngine metadataEngine, IEntityClass mainEntityClass, String profile) {
        this.classEngine = classEngine;
        this.metadataEngine = metadataEngine;
        this.mainEntityClass = mainEntityClass;
        this.profile = profile;
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public Collection<IEntityClass> getFatherEntityClass() {

        if (fatherEntityClasses == null) {
            if (null != metadataEngine) {
                List<Map<String, Object>> listFathers = metadataEngine.raw(g -> {
                    GraphTraversal<Vertex, Vertex> node = g.traversal().V()
                        .has(ID_INDEX, Long.toString(mainEntityClass.id())).emit().repeat(__.out(FATHER.name()))
                        .times(5).dedup().not(has(ID_INDEX, Long.toString(mainEntityClass.id())));
                    List<Map<String, Object>> list = new ArrayList<>();
                    while (node.hasNext()) {
                        Map<String, Object> map = new HashMap<>();
                        list.add(map);
                        Vertex next = node.next();
                        Iterator<VertexProperty<Object>> properties = next.properties();
                        while (properties.hasNext()) {
                            VertexProperty<Object> next1 = properties.next();
                            map.put(next1.key(), next1.value());
                        }
                    }
                    return list;
                });

                fatherEntityClasses = listFathers.stream()
                    .map(x -> classEngine.load(String.valueOf(x.get(ID_INDEX)), profile))
                    .filter(Optional::isPresent)
                    .map(Optional::get)
                    .collect(Collectors.toList());
            } else {
                return new ArrayList<>();
            }
        }
        return fatherEntityClasses;
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public Collection<IEntityClass> getChildrenEntityClass() {

        if (childrenEntityClasses == null) {
            if (null != metadataEngine) {
                List<Map<String, Object>> listFathers = metadataEngine.raw(g -> {
                    GraphTraversal<Vertex, Vertex> node = g.traversal().V()
                        .has(ID_INDEX, Long.toString(mainEntityClass.id())).emit().repeat(__.out(SON.name()))
                        .times(5).dedup().not(has(ID_INDEX, Long.toString(mainEntityClass.id())));
                    List<Map<String, Object>> list = new ArrayList<>();
                    while (node.hasNext()) {
                        Map<String, Object> map = new HashMap<>();
                        list.add(map);
                        Vertex next = node.next();
                        Iterator<VertexProperty<Object>> properties = next.properties();
                        while (properties.hasNext()) {
                            VertexProperty<Object> next1 = properties.next();
                            map.put(next1.key(), next1.value());
                        }
                    }
                    return list;
                });

                childrenEntityClasses = listFathers.stream()
                    .map(x -> classEngine.load(String.valueOf(x.get(ID_INDEX)), profile))
                    .filter(Optional::isPresent)
                    .map(Optional::get)
                    .collect(Collectors.toList());
            } else {
                return new ArrayList<>();
            }
        }
        return childrenEntityClasses;
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public Collection<IRelation> getAllRelations() {
        List<IRelation> allRelation = new LinkedList<>(mainEntityClass.relations());
        getFatherEntityClass().stream().flatMap(x -> x.relations().stream()).forEach(allRelation::add);
        return allRelation;
    }

    //TODO
    @Override
    public Collection<IEntityField> getAllFields() {
        List<IEntityField> allFields = new ArrayList<>(mainEntityClass.fields());
        getFatherEntityClass().stream().flatMap(x -> x.fields().stream()).forEach(allFields::add);
        return allFields;
    }

    @Override
    public Optional<IEntityField> field(String rawCode) {
        Optional<IEntityField> field = mainEntityClass.field(rawCode);
        if (!field.isPresent()) {
            return getFatherEntityClass().stream().map(x -> x.field(rawCode)).filter(Optional::isPresent).map(Optional::get).findFirst();
        } else {
            return field;
        }
    }

    @Override
    public Optional<IEntityField> field(long fieldId) {
        Optional<IEntityField> field = mainEntityClass.field(fieldId);
        if (!field.isPresent()) {
            return getFatherEntityClass().stream().map(x -> x.field(fieldId)).filter(Optional::isPresent).map(Optional::get).findFirst();
        } else {
            return field;
        }
    }

    @Override
    public Optional<IRelation> relation(long relationId) {
        Optional<IRelation> first = mainEntityClass.relations().stream().filter(x -> x.getId() == relationId).findFirst();
        if (!first.isPresent()) {
            return getFatherEntityClass().stream().flatMap(x -> x.relations().stream()).filter(x -> x.getId() == relationId).findFirst();
        } else {
            return first;
        }
    }

    @Override
    public Optional<IRelation> relation(String relationCode) {
        Optional<IRelation> first = mainEntityClass.relations().stream().filter(x -> x.getName().equalsIgnoreCase(relationCode)).findFirst();
        if (!first.isPresent()) {
            return getFatherEntityClass().stream().flatMap(x -> x.relations().stream()).filter(x -> x.getName().equalsIgnoreCase(relationCode)).findFirst();
        } else {
            return first;
        }
    }

    /**
     * related
     *
     * @param relatedCode
     * @return
     */
    @Override
    public Optional<IEntityClass> relatedEntityClass(String relatedCode) {
        //find from main to father
        Optional<IRelation> first = mainEntityClass.relations().stream().filter(x -> x.getRelOwnerClassId() == mainEntityClass.id()).filter(x -> x.getName().equals(relatedCode)).findFirst();

        if (first.isPresent()) {
            return classEngine.load(String.valueOf(first.get().getEntityClassId()), profile);
        } else {
            Optional<IRelation> relationInParent = getFatherEntityClass().stream().map(x -> {
                return x.relations().stream()
                        .filter(rel -> rel.getRelOwnerClassId() == x.id())
                        .filter(rel -> rel.getName().equals(relatedCode)).findFirst();
            }).filter(Optional::isPresent).map(Optional::get).findFirst();

            return relationInParent.flatMap(x -> classEngine.load(String.valueOf(x.getEntityClassId()), profile));
        }
    }

    @Override
    public IEntityClass getEntityClass() {
        return mainEntityClass;
    }

    @Override
    public String profile() {
        return profile;
    }

    /**
     * get real profile from all father entities
     * @return
     */
    @Override
    public String realProfile() {
        String profile = mainEntityClass.realProfile();
        if(StringUtils.isEmpty(profile)) {
            Optional<String> first = fatherEntityClasses.stream().map(IEntityClass::realProfile).filter(cs -> !StringUtils.isEmpty(cs)).findFirst();
            if(first.isPresent()) {
                return profile;
            } else {
                return null;
            }
        } else {
            return profile;
        }
    }

    /**
     * TODO constraint
     * @param rawName
     * @return
     */
    @Override
    public EntityClassGroup relatedEntityClassWithRawName(String rawName) {
//        //find from main to father
//        Optional<IRelation> first = mainEntityClass.relations().stream()
//                .filter(x -> x.getRelOwnerClassId() == mainEntityClass.id())
//                .filter(x -> x.getName().equals(relatedCode)).findFirst();
//
//        if (first.isPresent()) {
//            return classEngine.load(String.valueOf(first.get().getEntityClassId()), profile);
//        } else {
//            Optional<IRelation> relationInParent = getFatherEntityClass().stream().map(x -> {
//                return x.relations().stream()
//                        .filter(rel -> rel.getRelOwnerClassId() == x.id())
//                        .filter(rel -> rel.getName().equals(relatedCode)).findFirst();
//            }).filter(Optional::isPresent).map(Optional::get).findFirst();
//
//            return relationInParent.flatMap(x -> classEngine.load(String.valueOf(x.getEntityClassId()), profile));
//        }
//        if(relatedEntityClassCodes == null) {
//
//        }
        Optional<IEntityClass> targetEntityClass = classEngine.loadByCode(rawName, profile);
        if(targetEntityClass.isPresent()) {
            IEntityClass entityClass = targetEntityClass.get();
            return classEngine.describe(entityClass, profile());
        }
        throw new RuntimeException("EntityClass not found:" + rawName);
    }

    @Override
    public EntityClassEngine classEngine() {
        return classEngine;
    }

    @Override
    public Record toRecordNew(Map<Tuple2<String, Long>, Object> body, long entityClassId) {
        IEntityClass targetClass;
        Collection<IEntityField> fieldsList = Collections.emptyList();
        if (mainEntityClass.id() == entityClassId || entityClassId == 0) {
            targetClass = mainEntityClass;
            fieldsList = getAllFields();
        } else {
            Optional<IEntityClass> targetOp = fatherEntityClasses.stream().filter(x -> x.id() == entityClassId).findFirst();
            if (targetOp.isPresent()) {
                targetClass = targetOp.get();
                fieldsList = classEngine.describe(targetClass, profile).getAllFields();
            } else {
                targetOp = childrenEntityClasses.stream().filter(x -> x.id() == entityClassId).findFirst();
                if (targetOp.isPresent()) {
                    targetClass = targetOp.get();
                    fieldsList = classEngine.describe(targetClass, profile).getAllFields();
                }
            }
        }

        List<IEntityField> finalFieldList = new ArrayList<>(fieldsList);

        //add related fields
        body.entrySet().stream().map(entry -> {
            String s = entry.getKey()._1;
            return s;
        }).filter(s -> {
            return s.startsWith("_") && s.contains(".");
        }).distinct().forEach(x -> {
            Optional<ColumnField> column = this.column(x);
            if(column.isPresent()) {
                finalFieldList.add(column.get());
            }
        });

        Record record = new GeneralRecord(finalFieldList, 0);
        record.setTypeId(entityClassId);

        finalFieldList.forEach((x) -> {
            record.set(x, body.get(Tuple.of(x.name(), x.id())));
            if(x.name().equalsIgnoreCase("id")) {
                Optional<Object> o = record.get(x);
                o.ifPresent(id -> {
                    record.setId(Long.parseLong(id.toString()));
                });
            }
        });

        return record;
    }

    //TODO
    @Override
    public Optional<ColumnField> column(String fieldCode) {
        //return mainEntityClass.fields().stream().filter(x -> x.acceptName(fieldCode)).map(x -> new ColumnField(fieldCode, x, mainEntityClass)).findAny();
        Optional<ColumnField> column = classEngine.column(this.getEntityClass(), ResourcePath.parse("@".concat(mainEntityClass.code()).concat(reCalculate(fieldCode))), profile);
        column.ifPresent(x -> x.setName(fieldCode));
        return column;
    }

    private String reCalculate(String fieldCode) {
        if(fieldCode.startsWith("_") && fieldCode.contains(".")) {
            String[] split = fieldCode.substring(1).split("\\.");
            StringBuilder sb = new StringBuilder();
            int i = 0;
            boolean lastPartIsMain = false;
            for(; i < split.length - 1 ; i ++) {
                if(i == 0) {
                    sb.append("#_").append(split[i]);
                } else {
                    if(i == split.length - 1) {
                        if(!split[i].startsWith("_")) {
                            lastPartIsMain = true;
                        }
                    }
                    sb.append("#").append(split[i]);
                }
            }

            if(lastPartIsMain) {
                sb.append("#").append(split[i]);
            } else {
                sb.append(".").append(split[i]);
            }
            return sb.toString();
        }

        return "#".concat(fieldCode);
    }

    @Override
    public List<ColumnField> columns(String fieldCode) {
        return classEngine.columns(this.getEntityClass(), ResourcePath.parse("@".concat(mainEntityClass.code()).concat(reCalculate(fieldCode))), profile);
    }

    @Override
    public List<ColumnField> columns() {
        Stream<ColumnField> mainFields = mainEntityClass.fields().stream().map(x -> new ColumnField(x.name(), x, mainEntityClass));
        Stream<ColumnField> fatherFields = getFatherEntityClass().stream().flatMap(x -> x.fields()
                .stream().map(field -> new ColumnField(x.name(), field, x)));

        return Stream.concat(mainFields, fatherFields).collect(Collectors.toList());
    }

    @Override
    public void onRefresh(Object payload) {
        this.fatherEntityClasses = null;
        this.childrenEntityClasses = null;
    }
}
