package com.xforceplus.ultraman.metadata.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import lombok.extern.slf4j.Slf4j;

/**
 * pretty print to show yaml
 */
@Slf4j
public class PrettyPrinter {

    private final static ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());

    public static String print(Object obj) {
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            log.warn("{}", e);
            return "";
        }
    }
}