package com.xforceplus.ultraman.metadata.domain.vo.dto;

/**
 *
 * @param <T>
 */
public class Response<T> {

    public static final String OK = "1";
    public static final String Fail = "-1";
    private String code;
    private String message;
    private T result;

    public Response() {
    }

    public Response(String code, String message, T result) {
        this.code = code;
        this.message = message;
        this.result = result;
    }

    public static Response ok(String message) {
        Response response = new Response();
        response.setCode(OK);
        response.setMessage(message);
        return response;
    }

    public static Response failed(String message) {
        Response response = new Response();
        response.setCode(Fail);
        response.setMessage(message);
        return response;
    }

    public static Response Error(String message){
        return Response.failed(message);
    }

    public static Response from(String code, String message) {
        Response response = new Response();
        response.setCode(code);
        response.setMessage(message);
        return response;
    }

    public static <T> Response<T> from(String code, String message, T result) {
        Response response = new Response();
        response.setCode(code);
        response.setMessage(message);
        response.setResult(result);
        return response;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    @Override
    public String toString() {
        return "Response{" +
                "code='" + code + '\'' +
                ", message='" + message + '\'' +
                ", result=" + result +
                '}';
    }
}