/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.domain.record;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.helper.ConvertHelper;
import com.xforceplus.ultraman.metadata.helper.PrettyPrinter;
import com.xforceplus.ultraman.metadata.helper.PropertyHelper;
import com.xforceplus.ultraman.metadata.values.IValue;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralRecord
implements Record {
    private static final Logger log = LoggerFactory.getLogger(GeneralRecord.class);
    private final Object[] values;
    private final IEntityField[] fields;
    private final Boolean isEmpty;
    private Long id;
    private Long parentId;
    private Long typeId;
    private Integer version;

    public static Record empty() {
        return new GeneralRecord();
    }

    private GeneralRecord() {
        this.isEmpty = true;
        this.values = null;
        this.fields = null;
    }

    @Deprecated
    public GeneralRecord(Collection<? extends IEntityField> fields) {
        this(fields, null);
    }

    public GeneralRecord(Collection<? extends IEntityField> fields, Integer version) {
        int size = fields.size();
        this.fields = new IEntityField[fields.size()];
        this.values = new Object[size];
        int i = 0;
        Iterator<? extends IEntityField> iterator = fields.iterator();
        while (iterator.hasNext()) {
            IEntityField field;
            this.fields[i] = field = iterator.next();
            ++i;
        }
        this.isEmpty = false;
        this.version = version;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Long getTypeId() {
        return this.typeId;
    }

    @Override
    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public List<ColumnField> fields(IEntityClass relatedClass) {
        return Arrays.stream(this.fields).map(x -> new ColumnField(x.name(), (IEntityField)x, relatedClass)).collect(Collectors.toList());
    }

    @Override
    public List<ColumnField> fields(String prefix, IEntityClass relatedClass) {
        return this.fields(relatedClass).stream().map(x -> new ColumnField("_".concat(prefix).concat(".").concat(x.name()), (IEntityField)x, x.originEntityClass())).collect(Collectors.toList());
    }

    @Override
    public List<Object> values() {
        return Arrays.asList(this.values);
    }

    public void setValues(List<Object> inputValues) {
        int i = 0;
        Iterator<Object> iterator = inputValues.iterator();
        while (iterator.hasNext()) {
            Object inputValue;
            this.values[i] = inputValue = iterator.next();
            ++i;
        }
    }

    @Override
    public Long getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @Override
    public Optional<Object> get(String fieldName) {
        return this.field(fieldName).flatMap(this::get);
    }

    @Override
    public Object get(int index) {
        if (index >= this.values.length) {
            log.error("OutOfBound exception for visit index:{} and return null!", (Object)index);
            return null;
        }
        return this.values[index];
    }

    private Optional<IEntityField> field(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        if (fieldName.startsWith("_")) {
            fieldName = fieldName.substring(1);
        }
        IEntityField fieldMatch = null;
        for (IEntityField f : this.fields) {
            String targetFieldName = f.name();
            if (targetFieldName.startsWith("_")) {
                targetFieldName = targetFieldName.substring(1);
            }
            if (!fieldName.equals(targetFieldName)) continue;
            if (fieldMatch == null) {
                fieldMatch = f;
                continue;
            }
            log.warn("Ambiguous match found for " + fieldName + ". Both " + fieldMatch + " and " + f + " match.");
        }
        return Optional.ofNullable(fieldMatch);
    }

    private final int indexOf(IEntityField field) {
        if (field != null) {
            int i;
            int size = this.fields.length;
            for (i = 0; i < size; ++i) {
                if (this.fields[i] != field) continue;
                return i;
            }
            for (i = 0; i < size; ++i) {
                if (!this.fields[i].equals(field)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Optional<Object> get(IEntityField field) {
        int index = this.indexOf(field);
        if (index > -1 && index < this.values.length) {
            return Optional.ofNullable(this.values[index]);
        }
        return Optional.empty();
    }

    @Override
    public Optional<IValue> getTypedValue(String fieldName) {
        return this.field(fieldName).flatMap(this::getTypedValue);
    }

    @Override
    public Optional<IValue> getTypedValue(IEntityField field) {
        return this.get(field).flatMap(x -> field.type().toTypedValue(field, x.toString()));
    }

    @Override
    public <T> Optional<T> get(String fieldName, Class<? extends T> type) {
        return this.field(fieldName).flatMap(this::get).map(x -> x);
    }

    @Override
    public <T> Optional<T> get(IEntityField field, Class<? extends T> type) {
        return this.get(field).map(x -> x);
    }

    @Override
    public <T> Optional<T> get(TypedField<T> typedField) {
        Optional<Object> o = this.get(typedField.code());
        if (o.isPresent()) {
            if (o.get().getClass().isAssignableFrom(typedField.getClass())) {
                return o.map(x -> x);
            }
            return o.map(x -> ConvertHelper.bean.getConvertUtils().convert(x.toString(), typedField.type()));
        }
        return Optional.empty();
    }

    @Override
    public <T> void set(TypedField<T> typedField, T t) {
        this.set(typedField.code(), t);
    }

    @Override
    public void set(String fieldName, Object t) {
        this.field(fieldName).ifPresent(x -> this.set((IEntityField)x, t));
    }

    @Override
    public void set(IEntityField field, Object t) {
        int index = this.indexOf(field);
        if (index > -1 && index < this.values.length) {
            this.values[index] = t;
        } else {
            log.warn("{} is not present", (Object)field.name());
        }
    }

    @Override
    public void fromMap(Map<String, Object> map) {
        map.forEach(this::set);
    }

    @Override
    public void setTypedValue(IValue iValue) {
        if (iValue != null && iValue.getValue() != null && iValue.getField() != null) {
            this.set(iValue.getField(), iValue.getValue());
        }
    }

    @Override
    public <T> T into(Class<T> targetClass) {
        try {
            Object o = targetClass.newInstance();
            Map<String, Object> map = this.toMap(Collections.emptySet());
            map.forEach((k, v) -> {
                if (v != null) {
                    String s = PropertyHelper.convertToCamel(k);
                    try {
                        ConvertHelper.bean.setProperty(o, s, v);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            return o;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Tuple2<IEntityField, Object>> stream() {
        return IntStream.range(0, this.fields.length).mapToObj(i -> Tuple.of((Object)this.fields[i], (Object)this.values[i]));
    }

    @Override
    public Stream<Tuple2<IEntityField, Object>> stream(Set<String> filterName) {
        return IntStream.range(0, this.fields.length).mapToObj(i -> {
            String name = this.fields[i].name();
            if (filterName != null && !filterName.isEmpty()) {
                if (name.startsWith("_")) {
                    name = name.substring(1);
                }
                if (filterName.contains(name)) {
                    return Tuple.of((Object)this.fields[i], (Object)this.values[i]);
                }
                return null;
            }
            return Tuple.of((Object)this.fields[i], (Object)this.values[i]);
        }).filter(Objects::nonNull);
    }

    @Override
    public Stream<Tuple2<IEntityField, Object>> stream(List<String> orderedKeys) {
        if (orderedKeys == null || orderedKeys.isEmpty()) {
            return this.stream();
        }
        return orderedKeys.stream().map(x -> {
            Optional<IEntityField> fieldOp = this.field((String)x);
            return fieldOp.map(entityField -> Tuple.of((Object)entityField, this.get((IEntityField)entityField).orElse(null))).orElse(null);
        }).filter(Objects::nonNull);
    }

    @Override
    public Map<String, Object> toMap(Set<String> filterName) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.values.length + 1);
        IntStream.range(0, this.values.length).forEach(i -> {
            String name = this.fields[i].name();
            if (filterName != null && !filterName.isEmpty()) {
                if (this.isInSet(filterName, name)) {
                    if (name.startsWith("_")) {
                        map.put(name.substring(1), this.values[i]);
                    } else {
                        map.put(name, this.values[i]);
                    }
                }
            } else {
                map.put(name, this.values[i]);
            }
        });
        if (this.id != null) {
            map.putIfAbsent("id", this.id.toString());
        }
        return map;
    }

    private boolean isInSet(Set<String> filterName, String key) {
        String[] split;
        String prefixKey;
        List starSet = filterName.stream().filter(x -> x.endsWith(".*")).map(x -> x.substring(0, x.length() - 2)).collect(Collectors.toList());
        if (key.contains(".") && starSet.contains(prefixKey = (split = key.split("\\."))[0])) {
            return true;
        }
        return filterName.contains(key);
    }

    private String normalizeKey(String key) {
        return key.startsWith("_") ? key.substring(1) : key;
    }

    @Override
    public Map<String, Object> toNestedMap(Set<String> filterName) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.values.length);
        IntStream.range(0, this.values.length).forEach(i -> {
            String name = this.normalizeKey(this.fields[i].name());
            Boolean insert = false;
            if (filterName != null && !filterName.isEmpty()) {
                if (filterName.contains(name)) {
                    insert = true;
                }
            } else {
                insert = true;
            }
            if (insert.booleanValue()) {
                if (name.contains(".")) {
                    String[] names = name.split("\\.");
                    HashMap<String, Object> currentMap = map;
                    for (int index = 0; index < names.length - 1; ++index) {
                        String seg = names[index];
                        Object segMap = currentMap.get(seg);
                        if (segMap == null) {
                            HashMap<String, Object> innerMap = new HashMap<String, Object>();
                            currentMap.put(seg, innerMap);
                            currentMap = innerMap;
                            continue;
                        }
                        if (!(segMap instanceof Map)) continue;
                        currentMap = (Map)segMap;
                    }
                    currentMap.put(names[names.length - 1], this.values[i]);
                } else {
                    map.put(name, this.values[i]);
                }
            }
        });
        return map;
    }

    @Override
    public Boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public Boolean nonEmpty() {
        return this.isEmpty == false;
    }

    @Override
    public Integer version() {
        return this.version;
    }

    @Override
    public int compareTo(Record record) {
        return 0;
    }

    public String toString() {
        return PrettyPrinter.print(this);
    }
}

