package com.xforceplus.ultraman.metadata.domain.record;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.metadata.values.IValue;
import io.vavr.Tuple2;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

/**
 *
 */
public interface Record extends Comparable<Record> {

    Long getParentId();

    /**
     * always has a id;
     *
     * @return
     */
    Long getId();

    Long getTypeId();

    void setTypeId(Long typeId);

    void setId(Long id);

    List<ColumnField> fields(IEntityClass relatedClass);

    List<ColumnField> fields(String prefix, IEntityClass relatedClass);

    List<Object> values();

    void setParentId(Long id);

    Optional<Object> get(String fieldName);

    Object get(int index);

    Optional<Object> get(IEntityField field);

    Optional<IValue> getTypedValue(String fieldName);

    Optional<IValue> getTypedValue(IEntityField field);

    <T> Optional<T> get(String fieldName, Class<? extends T> type);

    <T> Optional<T> get(IEntityField field, Class<? extends T> type);

    <T> Optional<T> get(TypedField<T> typedField);

    <T> void set(TypedField<T> typedField, T t);

    void set(String fieldName, Object t);

    void set(IEntityField field, Object t);

    void fromMap(Map<String, Object> map);

    void setTypedValue(IValue iValue);

    /**
     * to a pojo
     *
     * @param targetClass
     * @param <T>
     * @return
     */
    <T> T into(Class<T> targetClass);

    Stream<Tuple2<IEntityField, Object>> stream();

    /**
     * filter the input key
     *
     * @param keys filter keys;
     * @return
     */
    Stream<Tuple2<IEntityField, Object>> stream(Set<String> keys);

    Stream<Tuple2<IEntityField, Object>> stream(List<String> orderedKeys);

    Map<String, Object> toMap(Set<String> keys);

    Map<String, Object> toNestedMap(Set<String> keys);

    Boolean isEmpty();

    Boolean nonEmpty();

    Integer version();
    
    void setVersion(Integer ver);

}
