package com.xforceplus.ultraman.metadata.entity;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by justin.xu on 04/2023.
 *
 * @since 1.8
 */
public class EntityIndex implements IIndex {

    private Set<String> indexes;

    private String indexName;

    private IndexType indexType;

    private IndexRelation indexRelation;

    @Override
    public boolean match(Collection<String> indexes) {
        Set<String> copy = new HashSet<>(indexes);
        if (this.indexes.size() != copy.size()) {
            return false;
        }

        for (String element : copy) {
            if (!this.indexes.contains(element)) {
                return false;
            }
        }

        return true;
    }

    @Override
    public boolean isUnique() {
        return indexType.equals(IndexType.UNIQUE);
    }

    @Override
    public Set<String> indexes() {
        return indexes;
    }


    public static final class Builder {
        private Set<String> indexes;

        private String indexName;

        private IndexType indexType;

        private IndexRelation indexRelation;

        private Builder() {
        }

        public static EntityIndex.Builder anEntityIndex() {
            return new EntityIndex.Builder();
        }

        public EntityIndex.Builder withIndexes(Set<String> indexes) {
            this.indexes = indexes;
            return this;
        }

        public EntityIndex.Builder withIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public EntityIndex.Builder withIndexRelation(IndexRelation indexRelation) {
            this.indexRelation = indexRelation;
            return this;
        }

        public EntityIndex.Builder withIndexType(IndexType indexType) {
            this.indexType = indexType;
            return this;
        }


        /**
         * 构造实例.
         *
         * @return 实例.
         */
        public EntityIndex build() {
            EntityIndex entityIndex = new EntityIndex();
            entityIndex.indexes = this.indexes == null ? new HashSet<>() : this.indexes;
            entityIndex.indexName = this.indexName;
            entityIndex.indexRelation = this.indexRelation;
            entityIndex.indexType = this.indexType;

            return entityIndex;
        }
    }
}
