package com.xforceplus.ultraman.metadata.entity.calculation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ultraman.metadata.entity.CalculationType;

import java.util.StringJoiner;

/**
 * Created by justin.xu on 07/2021.
 *
 * @since 1.8
 */
public class Lookup extends AbstractCalculation {

    /**
     * lookup的类型标识.
     */
    @JsonProperty(value = "classId")
    private long classId;

    /**
     * lookup的字段标识.
     */
    @JsonProperty(value = "fieldId")
    private long fieldId;

    /**
     * lookup的关系信息.
     */
    @JsonProperty(value = "relationId")
    private long relationId;

    public long getClassId() {
        return classId;
    }

    public void setClassId(long classId) {
        this.classId = classId;
    }

    public long getFieldId() {
        return fieldId;
    }

    public void setFieldId(long fieldId) {
        this.fieldId = fieldId;
    }

    public long getRelationId() {
        return relationId;
    }

    public void setRelationId(long relationId) {
        this.relationId = relationId;
    }

    private Lookup() {
        super(CalculationType.LOOKUP);
    }

    @Override
    public AbstractCalculation clone() {
        Lookup lookup = new Lookup();
        lookup.classId = this.classId;
        lookup.fieldId = this.fieldId;
        lookup.relationId = this.relationId;
        lookup.level = this.level;
        return lookup;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", Lookup.class.getSimpleName() + "[", "]")
            .add("classId=" + classId)
            .add("fieldId=" + fieldId)
            .add("relationId=" + relationId)
            .toString();
    }

    /**
     * builder.
     */
    public static final class Builder {
        private long classId;
        private long fieldId;
        private long relationId;

        private Builder() {
        }

        public static Builder anLookup() {
            return new Builder();
        }

        public Builder withClassId(long classId) {
            this.classId = classId;
            return this;
        }

        public Builder withFieldId(long fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public Builder withRelationId(long relationId) {
            this.relationId = relationId;
            return this;
        }

        /**
         * build.
         */
        public Lookup build() {
            Lookup lookup = new Lookup();
            lookup.calculationType = CalculationType.LOOKUP;
            lookup.classId = this.classId;
            lookup.fieldId = this.fieldId;
            lookup.relationId = this.relationId;
            lookup.level = StaticCalculation.DEFAULT_LEVEL;
            return lookup;
        }
    }
}
