package com.xforceplus.ultraman.metadata.entity.impl;

import com.xforceplus.metadata.schema.typed.BoRelationship;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import org.apache.commons.lang.StringUtils;

import java.util.function.Consumer;

public class LazyRelation implements IRelation, Refreshable {

    private BoRelationship boRelationship;

    public LazyRelation(BoRelationship boRelationship) {
        this.boRelationship = boRelationship;
    }

    @Override
    public Long getId() {
        return Long.parseLong(boRelationship.getId());
    }

    @Override
    public String getName() {
        return boRelationship.getRelationCode();
    }

    @Override
    public long getEntityClassId() {
        return Long.parseLong(boRelationship.getJoinBoId());
    }

    @Override
    public String getRelationType() {
        return boRelationship.getRelationType();
    }

    /**
     * TODO
     * @return
     */
    @Override
    public boolean isIdentity() {
        return false;
    }

    /**
     * TODO
     * @return
     */
    @Override
    public IEntityField getEntityField() {
        return null;
    }

    /**
     * TODO
     */
    @Override
    public String getEntityClassName() {
        return null;
    }

    /**
     * TODO
     * @return
     */
    @Override
    public long getRelOwnerClassId() {
        return Long.parseLong(boRelationship.getBoId());
    }

    @Override
    public String getRelOwnerClassName() {
        return boRelationship.getRelationName();
    }

    @Override
    public boolean isStrong() {
        return boRelationship.isStrong();
    }

    @Override
    public boolean isCompanion() {
        return !StringUtils.isEmpty(boRelationship.getCompanionRelationId());
    }

    @Override
    public boolean isSelfRelation(long id) {
        boolean joinBoId = !StringUtils.isEmpty(boRelationship.getJoinBoId());
        boolean boId = !StringUtils.isEmpty(boRelationship.getBoId());

        if(joinBoId && boId) {
            return boRelationship.getJoinBoId().equals(boRelationship.getBoId());
        }

        return false;
    }

    @Override
    public void onRefresh(Object payload) {

    }

    @Override
    public String toString() {
        return "LazyRelation{" +
                "boRelationship=" + boRelationship +
                '}';
    }
}
