package com.xforceplus.ultraman.metadata.entity.legacy.impl;

import com.xforceplus.ultraman.metadata.entity.CalculationType;
import com.xforceplus.ultraman.metadata.entity.FieldConfig;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.infra.Wrapped;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

/**
 * @author admin
 */
public class AliasField implements IEntityField, Wrapped<IEntityField>, Serializable {

    /**
     * origin field
     */
    private final IEntityField originField;

    private Set<String> alias = new HashSet<>();

    public AliasField(IEntityField originField) {
        this.originField = originField;
        alias.add(originField.name());
    }

    public void addName(String name) {
        alias.add(name);
    }

    @Override
    public long id() {
        return originField.id();
    }

    @Override
    public String name() {
        return String.join(",", alias);
    }

    public String firstName() {
        return alias.stream().findFirst().orElse("");
    }

    public String filterName(String name) {
        return alias.stream().filter(x -> x.equals(name)).findFirst().orElse("");
    }

    @Override
    public String cnName() {
        return originField.cnName();
    }

    @Override
    public FieldType type() {
        return originField.type();
    }

    @Override
    public FieldConfig config() {
        return originField.config();
    }

    @Override
    public String dictId() {
        return originField.dictId();
    }

    @Override
    public String defaultValue() {
        return originField.defaultValue();
    }

    @Override
    public IEntityField clone() {
        AliasField field = new AliasField(originField.clone());
        alias.forEach(field::addName);
        return field;
    }

    @Override
    public boolean isDynamic() {
        return originField.isDynamic();
    }

    @Override
    public CalculationType calculationType() {
        return originField.calculationType();
    }

    @Override
    public String realProfile() {
        return originField.realProfile();
    }

    @Override
    public String toString() {
        return "AliasField{" +
                "id=" + id() +
                ", alias=" + alias +
                ", originField=" + originField +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AliasField field = (AliasField) o;
        return Objects.equals(originField, field.originField) &&
                Objects.equals(alias, field.alias);
    }

    @Override
    public int hashCode() {
        return Objects.hash(originField, alias);
    }

    @Override
    public IEntityField getOriginObject() {
        return originField;
    }
}
