package com.xforceplus.ultraman.metadata.helper;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;

import java.util.Locale;

/**
 * property helper to generate field
 */
public class PropertyHelper {

    public static final String REL_PREFIX = "_";

    public static final String REL_DELIMITER = ".";

    public static final String TYPE_REL_DELIMITER = "$";

    private static final char CASE_DELIMITER = '_';

    /**
     * generate string field name with related code and field name
     *
     * @param code
     * @param fieldName
     * @return
     */
    public static String generateRelatedFieldName(String code, String fieldName) {
        StringBuffer sb = new StringBuffer();
        sb.append(REL_PREFIX);
        sb.append(code);
        sb.append(REL_DELIMITER);
        sb.append(fieldName);
        return sb.toString();
    }

    /**
     * extract name to code and fieldName
     *
     * @param name
     * @return
     */
    public static Tuple2<String, String> extractRelated(String name) {

        if (name.startsWith(REL_PREFIX)) {
            String[] nameArray = name.split("\\" + REL_DELIMITER);
            if (nameArray.length > 1) {
                return Tuple.of(nameArray[0].substring(1), nameArray[1]);
            }
        }

        return null;
    }

    /**
     * type property is camel
     * @return
     */
    public static String camelToBoProperty(String camelCase, boolean toSnake){

        String propertyStr = camelCase.replaceAll("\\" +TYPE_REL_DELIMITER, REL_DELIMITER);
        String fieldName = "";
        if(propertyStr.contains(REL_DELIMITER)){
            //a relation
            String[] split = propertyStr.split("\\" + REL_DELIMITER);
            if(split.length > 1){
                String relationCode = split[0];
                if(toSnake) {
                    fieldName = generateRelatedFieldName(relationCode
                            , camelCaseToUnderscore(split[1]));
                } else {
                    fieldName = generateRelatedFieldName(relationCode, split[1]);
                }
            } else {
                throw new RuntimeException("length error");
            }
        } else {
            if(toSnake) {
                fieldName = camelCaseToUnderscore(propertyStr);
            } else {
                fieldName = propertyStr;
            }
        }
        return fieldName;
    }

    private static String camelCaseToUnderscore(final String camelCase) {
        final String[] camelCaseParts = org.apache.commons.lang3.StringUtils.splitByCharacterTypeCamelCase(camelCase);
        for (int i = 0; i < camelCaseParts.length; i++) {
            camelCaseParts[i] = camelCaseParts[i].toLowerCase(Locale.ENGLISH);
        }
        return StringUtils.join(camelCaseParts, "_");
    }

    /**
     * snake
     * @return
     */
    private static boolean isSnake(String snake){
        return snake.indexOf(CASE_DELIMITER) > 1;
    }

//    public static Optional<String> getColumnName(IEntityClassReader reader, String key){
//
//        String snakeCase;
//        String camelCase;
//        if(isSnake(key)){
//            snakeCase = key;
//            camelCase = convertToCamel(key);
//        }else{
//            snakeCase = camelToBoProperty(key, true);
//            camelCase = convertToCamel(key);
//        }
//
//        Optional<ColumnField> columnSnake = reader.column(snakeCase);
//        Optional<ColumnField> columnCamel = reader.column(camelCase);
//
//        Optional<ColumnField> combine = OptionalHelper.combine(columnCamel, columnSnake);
//
//        return combine.map(ColumnField::name);
//    }

    /**
     * input also can be camel
     * key to camelCase and with $
     * @param input
     * @return
     */
    public static String convertToCamel(String input){
        String s = null;
        if(input.contains(REL_DELIMITER)){
            //snake to camel
            String[] split = input.split("\\" + REL_DELIMITER);
            if(split.length > 1){
                String code = split[0];
                String field  = convertToProperty(split[1]);
                s = code.concat(TYPE_REL_DELIMITER).concat(field);
            }
        } else {
            s = convertToProperty(input);
        }
        return s;
    }

    private static String convertToProperty(String keyName){
        if(keyName.contains(String.valueOf(CASE_DELIMITER))){
            //snake to camel
            return CaseUtils.toCamelCase(keyName, false, CASE_DELIMITER);
        } else {
            //camel
            return keyName;
        }
    }
}
