package com.xforceplus.ultraman.metadata.repository;

import com.xforceplus.ultraman.metadata.domain.vo.dto.*;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * metadata repository
 */
public interface MetadataRepository {

    List<String> codes();

    BoItem getBoDetailById(String id, String profile);

//    void save(ModuleUpResult moduleUpResult, String tenantId, String appId);

    Optional<IEntityClass> load(String tenantId, String appCode, String boId, String profile);

    Optional<IEntityClass> load(String tenantId, String appCode, String boId, String profile, String version);

    Optional<IEntityClass> loadByCode(String tenantId, String appCode, String boId, String profile, String version);

    Optional<IEntityClass> loadByCode(String tenantId, String appCode, String boCode, String profile);

    List<IEntityClass> findSubEntitiesById(String tenantId, String appCode, String boId, String profile);

    List<IEntityClass> findSubEntitiesById(String tenantId, String appCode, String boId, String profile, String version);

    List<IEntityClass> findSubEntitiesByCode(String tenantId, String appCode, String boCode, String profile);

    List<IEntityClass> findSubEntitiesByCode(String tenantId, String appCode, String boCode, String profile, String version);

//    void clearAllBoIdRelated(String boId, Long moduleId, UpdateableDataContext dc);

    SimpleBoItem findOneById(String boId);

    SimpleBoItem findOneById(String boId, String version);

    List<IEntityClass> findAllEntities(String profile);

    CurrentVersion currentVersion();

    List<BoInfoVo> loadSonBoInfoVo(String code, String profile);

    List<BoInfoVo> getAllBoInfo(String profile);

    BoInfoVo getBoInfo(String code, String profile);

    AppItem getCurrentApp();

    List<BoInfoVo> loadRelatedBoInfoVo(String code, String profile);

    ApiDetails loadApiByCodeAndEntityClass(String actionCode, long id);

    Set<String> findCustomActionsById(Long id);
}
