package com.xforceplus.ultraman.metadata.values;

import java.util.AbstractMap;
import java.util.Map;

/**
 * IValue附件约束规范.
 */
public class AttachmentConstraintHelper {

    /**
     * 组成字符串的每一个左封闭.
     */
    public static final char LEFT_CLOSE = '[';

    /**
     * 组成字符串的每一个右封闭.
     */
    public static final char RIGHT_CLOSE = ']';

    /**
     * 聚合字段附件内容key.
     */
    public static final String AGGREGATION_ATTACHMENT_KEY = "a";

    /**
     * lookup字段附件内容key.
     */
    public static final String LOOKUP_ATTACHMENT_KEY = "l";

    /**
     * 字段id附件信息key,默认附件，每个字段都有.
     */
    public static final String FIELD_ID_ATTACHMENT_KEY = "id";

    /**
     * 普通字段附件.
     */
    public static final String FIELD_STATIC_ATTACHMENT_KEY = "n";

    /**
     * 附件转字符串存储时的分隔符 key_value.
     */
    public static final char SPLIT = '_';

    /**
     * 解析附件,解析出KEY和value.<br>
     * 解析目标为 xxx_xxx这样的字符串.
     *
     * @param kv 目标字串.
     * @return 解析结果.
     */
    public static Map.Entry<String, String> parse(String kv) {
        StringBuilder buff = new StringBuilder();
        String k = null;
        for (char c : kv.toCharArray()) {
            if (c == SPLIT) {
                k = buff.toString();
                buff.delete(0, buff.length());
            } else {
                buff.append(c);
            }
        }

        if (k == null) {
            throw new IllegalArgumentException(
                String.format(
                    "Invalid attachment string (%s). Must be in \"key%s\"value\" mode.", kv, AttachmentConstraintHelper.SPLIT));
        }

        return new AbstractMap.SimpleEntry<String, String>(k, buff.toString());
    }
}
