package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;

/**
 * 表示 boolean 的属性名.
 *
 * @author wangzheng dongbin
 * @version 0.1 2020/2/18 20:54
 * @since 1.8
 */
public class BooleanValue extends AbstractValue<Boolean> {


    public BooleanValue(IEntityField field, Boolean value) {
        super(field, value);
    }

    public BooleanValue(IEntityField field, Boolean value, Attachment attachment) {
        super(field, value, attachment);
    }

    public BooleanValue(IEntityField field, Boolean value, String attachemnt) {
        super(field, value, attachemnt);
    }

    @Override
    Boolean fromString(String value) {

        if (value.equalsIgnoreCase("1")) {
            return true;
        }

        if (value.equalsIgnoreCase("0")) {
            return false;
        }

        return Boolean.valueOf(value);
    }

    @Override
    public long valueToLong() {
        return getValue() ? 1L : 0;
    }

    @Override
    public Integer storageValue() {
        return (null == getValue() || !getValue()) ? 0 : 1;
    }

    @Override
    protected IValue<Boolean> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        Attachment attachment = this.getAttachment().copy();
        attachment.add(attachmentKey, attachmentValue);
        return new BooleanValue(newField, getValue(), attachment);
    }

    @Override
    protected IValue<Boolean> doCopy(Boolean value) {
        return new BooleanValue(getField(), value, getAttachment().copy());
    }

}
