package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;

/**
 * 枚举值.
 *
 * @author wangzheng dongbin
 * @version 0.1 2020/2/18 20:54
 * @since 1.8
 */
public class EnumValue extends AbstractValue<String> {

    public EnumValue(IEntityField field, String value) {
        super(field, value);
    }

    public EnumValue(IEntityField field, String value, Attachment attachment) {
        super(field, value, attachment);
    }

    public EnumValue(IEntityField field, String value, String attachment) {
        super(field, value, attachment);
    }

    @Override
    String fromString(String value) {
        return value;
    }

    @Override
    public long valueToLong() {
        throw new UnsupportedOperationException("A string cannot be represented by a number.");
    }

    @Override
    public String storageValue() {
        return getValue();
    }

    @Override
    protected IValue<String> doCopy(IEntityField newField, String attachmentKey, String attachmentValue) {
        Attachment attachment = this.getAttachment().copy();
        attachment.add(attachmentKey, attachmentValue);
        return new EnumValue(newField, getValue(), attachment);
    }

    @Override
    protected IValue<String> doCopy(String value) {
        return new EnumValue(getField(), value, getAttachment().copy());
    }
}
