/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.engine.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.metadata.schema.dsl.utils.MatcherHelper;
import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.BoNode;
import com.xforceplus.ultraman.metadata.domain.vo.dto.AppItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoApiVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.CurrentVersion;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.engine.dsl.FieldsResource;
import com.xforceplus.ultraman.metadata.engine.dsl.MainFieldResource;
import com.xforceplus.ultraman.metadata.engine.dsl.RelatedEntityClassResource;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePart;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePath;
import com.xforceplus.ultraman.metadata.engine.dsl.RootResourcePart;
import com.xforceplus.ultraman.metadata.engine.dsl.SubEntityClassResource;
import com.xforceplus.ultraman.metadata.engine.impl.EntityClassGroupImpl;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.impl.LazyEntityClass;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.sdk.infra.CacheLike;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityClassEngineImpl
implements EntityClassEngine,
CacheLike {
    private static final Logger log = LoggerFactory.getLogger(EntityClassEngineImpl.class);
    private MetadataEngine metadataEngine;
    private Map<UnionKey, UnionKey> mappingKey = new ConcurrentHashMap<UnionKey, UnionKey>();
    private LoadingCache<UnionKey, IEntityClass> l2Cache;
    private LoadingCache<ProfiledEntityClass, EntityClassGroup> groupCache;
    private List<String> codes;

    public void onRefresh(Object payload) {
        this.refreshCache();
    }

    public void refreshCache() {
        this.l2Cache.invalidateAll();
        this.groupCache.invalidateAll();
        this.codes = null;
        this.mappingKey.clear();
    }

    public EntityClassEngineImpl(MetadataEngine metadataEngine) {
        this.metadataEngine = metadataEngine;
        this.l2Cache = Caffeine.newBuilder().maximumSize(1000L).build(key -> {
            log.debug("[Meta]Loading Entity {} from meta", key);
            Optional<Object> optionalEntity = Optional.empty();
            if (((UnionKey)key).id != null) {
                optionalEntity = ((UnionKey)key).version != null ? this.loadByIdAndVersionInner(String.valueOf(((UnionKey)key).id), ((UnionKey)key).version) : this.loadByIdAndProfileInner(String.valueOf(((UnionKey)key).id), ((UnionKey)key).profile);
            } else if (((UnionKey)key).code != null) {
                optionalEntity = ((UnionKey)key).version != null ? this.loadByCodeAndVersionInner(((UnionKey)key).code, ((UnionKey)key).version) : this.loadByCodeAndProfileInner(((UnionKey)key).code, ((UnionKey)key).profile);
            } else {
                return null;
            }
            if (optionalEntity.isPresent()) {
                IEntityClass entityClass = (IEntityClass)optionalEntity.get();
                UnionKey callKey = new UnionKey(((UnionKey)key).code, ((UnionKey)key).id, ((UnionKey)key).version, ((UnionKey)key).profile);
                UnionKey fullKey = new UnionKey(entityClass.code(), entityClass.id(), ((UnionKey)key).version, ((UnionKey)key).profile);
                this.mappingKey.put(fullKey, callKey);
                return entityClass;
            }
            return null;
        });
        this.groupCache = Caffeine.newBuilder().maximumSize(1000L).build(key -> {
            IEntityClass entityClass = ((ProfiledEntityClass)key).entityClass;
            String profile = ((ProfiledEntityClass)key).profile;
            log.info("[Meta]Construct Reader for Entity {}:{}", (Object)entityClass.id(), (Object)entityClass.code());
            return this.describeInner(entityClass, profile);
        });
    }

    private Optional<IEntityClass> loadByCodeAndVersionInner(String boCode, String version) {
        return (Optional)this.metadataEngine.read(() -> {
            Optional boNodeMapOp = this.metadataEngine.get(__.has((String)"nodeLabel", (Object)"Bo").has("code", (P)MatcherHelper.caseInsensitiveEq((String)boCode)));
            return boNodeMapOp.map(map -> {
                Optional appMap = this.metadataEngine.get(__.has((String)"nodeLabel", (Object)"App").where((Traversal)__.out((String[])new String[]{MetadataRelationType.HAS_BO.name()}).has("nodeLabel", (Object)"Bo").has("code", (P)MatcherHelper.caseInsensitiveEq((String)boCode))));
                Map appRealMap = (Map)appMap.get();
                BoNode boNode = new BoNode((Map)boNodeMapOp.get());
                return new LazyEntityClass(this.metadataEngine, appRealMap.get("code").toString(), boNode);
            });
        });
    }

    private Optional<IEntityClass> loadByIdAndVersionInner(String boId, String version) {
        return (Optional)this.metadataEngine.read(() -> {
            Optional boNodeMapOp = this.metadataEngine.get(__.has((String)"nodeLabel", (Object)"Bo").has("_id", (Object)boId));
            Optional appMapOp = this.metadataEngine.get(__.has((String)"nodeLabel", (Object)"App").where((Traversal)__.out((String[])new String[]{MetadataRelationType.HAS_BO.name()}).has("nodeLabel", (Object)"Bo").has("_id", (Object)boId)));
            return boNodeMapOp.map(map -> {
                Map appMap = (Map)appMapOp.get();
                BoNode boNode = new BoNode((Map)boNodeMapOp.get());
                return new LazyEntityClass(this.metadataEngine, appMap.get("code").toString(), boNode);
            });
        });
    }

    private Optional<IEntityClass> loadByIdAndProfileInner(String boId, String profile) {
        return (Optional)this.metadataEngine.read(() -> {
            List multi = this.metadataEngine.getMulti(__.has((String)"nodeLabel", (Object)"Bo").has("_id", (Object)boId).where((Traversal)org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.__.has((String)"profile", (P)MatcherHelper.caseInsensitiveEq((String)profile)).or(new Traversal[0]).hasNot("profile")));
            if (multi.isEmpty()) {
                return Optional.empty();
            }
            Optional<Map> boNodeMapOp = multi.stream().filter(x -> x.get("profile") != null).findFirst();
            Optional<Map> nullProfileOp = multi.stream().filter(x -> x.get("profile") == null).findFirst();
            Optional<Map> finalOne = boNodeMapOp.isPresent() ? boNodeMapOp : nullProfileOp;
            return finalOne.map(map -> {
                Optional appMap = this.metadataEngine.get(__.has((String)"nodeLabel", (Object)"App").where((Traversal)__.out((String[])new String[]{MetadataRelationType.HAS_BO.name()}).has("nodeLabel", (Object)"Bo").has("_id", (Object)boId)));
                Map appRealMap = (Map)appMap.get();
                BoNode boNode = new BoNode((Map)finalOne.get());
                return new LazyEntityClass(this.metadataEngine, appRealMap.get("code").toString(), boNode, profile);
            });
        });
    }

    private Optional<IEntityClass> loadByCodeAndProfileInner(String boCode, String profile) {
        return (Optional)this.metadataEngine.read(() -> {
            List multi = this.metadataEngine.getMulti(__.has((String)"nodeLabel", (Object)"Bo").has("code", (P)MatcherHelper.caseInsensitiveEq((String)boCode)).where((Traversal)org.apache.tinkerpop.gremlin.groovy.jsr223.dsl.credential.__.has((String)"profile", (P)MatcherHelper.caseInsensitiveEq((String)profile)).or(new Traversal[0]).hasNot("profile")));
            if (multi.isEmpty()) {
                return Optional.empty();
            }
            Optional<Map> boNodeMapOp = multi.stream().filter(x -> x.get("profile") != null).findFirst();
            Optional<Map> nullProfileOp = multi.stream().filter(x -> x.get("profile") == null).findFirst();
            Optional<Map> finalOne = boNodeMapOp.isPresent() ? boNodeMapOp : nullProfileOp;
            return finalOne.map(map -> {
                Optional appMap = this.metadataEngine.get(__.has((String)"nodeLabel", (Object)"App").where((Traversal)__.out((String[])new String[]{MetadataRelationType.HAS_BO.name()}).has("nodeLabel", (Object)"Bo").has("code", (P)MatcherHelper.caseInsensitiveEq((String)boCode))));
                Map appRealMap = (Map)appMap.get();
                BoNode boNode = new BoNode((Map)finalOne.get());
                return new LazyEntityClass(this.metadataEngine, appRealMap.get("code").toString(), boNode, profile);
            });
        });
    }

    @Override
    @WithSpan
    public List<String> codes() {
        if (this.codes != null) {
            return this.codes;
        }
        List code = this.metadataEngine.getMulti(__.has((String)"nodeLabel", (Object)"Bo"));
        this.codes = code.stream().map(x -> x.get("code").toString()).distinct().collect(Collectors.toList());
        return this.codes;
    }

    @Override
    public MetadataEngine meta() {
        return this.metadataEngine;
    }

    @Override
    public String appCode() {
        Optional stringObjectMap = this.metadataEngine.get(__.has((String)"nodeLabel", (Object)"App"));
        if (stringObjectMap.isPresent()) {
            return ((Map)stringObjectMap.get()).get("code").toString();
        }
        return "";
    }

    @Override
    @WithSpan
    public Optional<IEntityClass> load(String boId, String profile) {
        return this.loadByUnionKey(new UnionKey(null, Long.parseLong(boId), null, profile));
    }

    @Override
    @WithSpan
    public Optional<IEntityClass> load(String boId, String profile, String version) {
        return this.loadByUnionKey(new UnionKey(null, Long.parseLong(boId), version, profile));
    }

    @Override
    @WithSpan
    public Optional<IEntityClass> loadByCode(String boCode, String profile) {
        return this.loadByUnionKey(new UnionKey(boCode, null, null, profile));
    }

    private boolean isEquals(UnionKey a, UnionKey b) {
        if (a != null && b != null) {
            return ((a.code != null || b.code != null) && Objects.equals(a.code, b.code) || (a.id != null || b.id != null) && Objects.equals(a.id, b.id)) && Objects.equals(a.version, b.version) && Objects.equals(a.profile, b.profile);
        }
        return a == null && b == null;
    }

    private Optional<IEntityClass> loadByUnionKey(UnionKey callKey) {
        Optional<Object> entityClass;
        UnionKey inMappingKey = this.mappingKey.get(callKey);
        if (inMappingKey == null) {
            Optional<UnionKey> inCacheKey = this.mappingKey.entrySet().stream().filter(x -> this.isEquals((UnionKey)x.getKey(), callKey)).map(Map.Entry::getValue).findFirst();
            UnionKey finalKey = callKey;
            if (inCacheKey.isPresent()) {
                this.mappingKey.put(callKey, inCacheKey.get());
                finalKey = inCacheKey.get();
            }
            entityClass = Optional.ofNullable(this.l2Cache.get((Object)finalKey));
        } else {
            entityClass = Optional.ofNullable(this.l2Cache.get((Object)inMappingKey));
        }
        return entityClass;
    }

    @Override
    @WithSpan
    public Optional<IEntityClass> loadByCode(String boCode, String profile, String version) {
        return Optional.empty();
    }

    @Override
    @WithSpan
    public EntityClassGroup describe(IEntityClass entityClass, String profile) {
        return (EntityClassGroup)this.groupCache.get((Object)new ProfiledEntityClass(profile, entityClass));
    }

    private EntityClassGroup describeInner(IEntityClass entityClass, String profile) {
        return new EntityClassGroupImpl(this, this.metadataEngine, entityClass, profile);
    }

    @Override
    @WithSpan
    public List<ColumnField> columns(ResourcePath resourcePath, String profile) {
        return this.columns(null, resourcePath, profile);
    }

    @Override
    @WithSpan
    public List<ColumnField> columns(IEntityClass root, ResourcePath resourcePath, String profile) {
        if (!resourcePath.isMultiResource()) {
            log.warn("Cannot not find Multi resource on Single Path {}", (Object)resourcePath);
            return Collections.emptyList();
        }
        List<ColumnField> fields = this.columnsInner(root, resourcePath, profile);
        return fields;
    }

    @WithSpan
    public IEntityClass searchRelated(IEntityClass current, String relatedCode, String profile) {
        IEntityClass related = current.relations().stream().filter(x -> x.getRelOwnerClassId() == current.id()).filter(x -> x.getName().equals(relatedCode)).map(x -> this.load(String.valueOf(x.getEntityClassId()), profile)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
        if (related == null) {
            IEntityClass father = null;
            IEntityClass ptr = current;
            while (ptr.extendEntityClass() != null && related == null) {
                father = ptr.extendEntityClass();
                Optional<IEntityClass> fatherRawOp = this.load(Long.toString(father.id()), profile);
                if (fatherRawOp.isPresent()) {
                    IEntityClass finalFather = father = fatherRawOp.get();
                    related = father.relations().stream().filter(x -> x.getRelOwnerClassId() == finalFather.id()).filter(x -> x.getName().equals(relatedCode)).map(x -> this.load(String.valueOf(x.getEntityClassId()), profile)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
                    ptr = father;
                    continue;
                }
                log.warn("Father is not present while child says is father id:code {}:{}", (Object)father.id(), (Object)father.code());
                break;
            }
        }
        return related;
    }

    private List<ColumnField> columnsInner(IEntityClass root, ResourcePath resourcePath, String profile) {
        Iterator<ResourcePart> iterator = resourcePath.iterator();
        IEntityClass ptr = null;
        ArrayList<ColumnField> retList = new ArrayList<ColumnField>();
        while (iterator.hasNext()) {
            ResourcePart nextPart = iterator.next();
            if (nextPart instanceof RelatedEntityClassResource) {
                String relatedCode = ((RelatedEntityClassResource)nextPart).getRelatedCode();
                if (ptr != null) {
                    ptr = this.searchRelated(ptr, relatedCode, profile);
                }
                if (ptr != null) continue;
                break;
            }
            if (nextPart instanceof SubEntityClassResource) {
                String code;
                if (ptr != null && (ptr = this.searchSub(ptr, code = ((SubEntityClassResource)nextPart).getCode(), profile)) != null) continue;
                break;
            }
            if (nextPart instanceof RootResourcePart) {
                if (root == null) {
                    ptr = this.loadByCode(((RootResourcePart)nextPart).getCode(), profile).orElse(null);
                    if (ptr != null) continue;
                    break;
                }
                ptr = root;
                continue;
            }
            if (nextPart instanceof MainFieldResource) {
                String fieldCode = ((MainFieldResource)nextPart).getFieldCode();
                this.columnRaw(ptr, fieldCode, profile).ifPresent(retList::add);
                continue;
            }
            if (!(nextPart instanceof FieldsResource)) continue;
            retList.addAll(this.describe(ptr, profile).columns());
        }
        return retList;
    }

    @WithSpan
    public IEntityClass searchSub(IEntityClass current, String subCode, String profile) {
        Collection<IEntityClass> subClassList = current.childEntityClasses();
        IEntityClass retEntityClass = null;
        if (subClassList != null) {
            for (IEntityClass entityClass : subClassList) {
                if (entityClass.code().equals(subCode)) {
                    retEntityClass = entityClass;
                    break;
                }
                Optional<IEntityClass> sub = this.load(String.valueOf(entityClass.id()), profile);
                if (!sub.isPresent()) continue;
                retEntityClass = this.searchSub(sub.get(), subCode, profile);
            }
        }
        return retEntityClass;
    }

    private Optional<ColumnField> columnRaw(IEntityClass targetClass, String rawPart, String profile) {
        if (rawPart.contains("/")) {
            String[] sub = rawPart.split("/");
            String subCode = sub[0];
            String subField = sub[1];
            IEntityClass subEntityClass = this.searchSub(targetClass, subCode, profile);
            if (subEntityClass != null) {
                Optional<IEntityField> subFieldOp = subEntityClass.field(subField);
                return subFieldOp.map(x -> new ColumnField(x.name(), (IEntityField)x, subEntityClass));
            }
        } else {
            Optional<IEntityField> fieldOp = targetClass.field(rawPart);
            if (!fieldOp.isPresent() && targetClass.extendEntityClass() != null) {
                Optional<IEntityClass> parent = this.load(Long.valueOf(targetClass.extendEntityClass().id()).toString(), profile);
                if (parent.isPresent()) {
                    return this.columnRaw(parent.get(), rawPart, profile);
                }
                throw new RuntimeException("Parent " + targetClass.extendEntityClass().code() + " not found");
            }
            return fieldOp.map(x -> new ColumnField(x.name(), (IEntityField)x, targetClass));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ColumnField> column(ResourcePath resourcePath, String profile) {
        return this.column(null, resourcePath, profile);
    }

    @Override
    @WithSpan
    public Optional<ColumnField> column(IEntityClass root, ResourcePath resourcePath, String profile) {
        if (resourcePath.isMultiResource()) {
            log.warn("Cannot not find Single resource on Multi Path {}", (Object)resourcePath);
            return Optional.empty();
        }
        List<ColumnField> fields = this.columnsInner(root, resourcePath, profile);
        if (!fields.isEmpty()) {
            return Optional.ofNullable(fields.get(0));
        }
        return Optional.empty();
    }

    @Override
    @WithSpan
    public List<IEntityClass> findAllEntities(String profile) {
        return (List)this.metadataEngine.read(() -> this.codes().stream().map(x -> this.loadByCode((String)x, profile)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public Set<String> findCustomActionsById(long id) {
        return Collections.emptySet();
    }

    @Override
    public List<BoApiVo> loadApiByCode(String code, String profile) {
        List multi = this.metadataEngine.getMulti(__.has((String)"code", (P)MatcherHelper.caseInsensitiveEq((String)code)).outE(new String[]{MetadataRelationType.HAS_API.name()}).inV());
        return multi.stream().map(x -> {
            BoApiVo boApiVo = new BoApiVo();
            boApiVo.setCode(String.valueOf(x.get("code")));
            boApiVo.setBoId(Long.parseLong(String.valueOf(x.get("boId"))));
            boApiVo.setMethod(String.valueOf(x.get("method")));
            boApiVo.setUrl(String.valueOf(x.get("url")));
            boApiVo.setName(String.valueOf(x.get("name")));
            boApiVo.setParam(String.valueOf(x.get("params")));
            return boApiVo;
        }).collect(Collectors.toList());
    }

    @Override
    public CurrentVersion currentVersion() {
        String appVersion = this.getCurrentApp().getAppVersion();
        List code = this.metadataEngine.getMulti(__.has((String)"nodeLabel", (Object)"Bo"));
        List<String> ids = code.stream().map(x -> x.get("id").toString()).distinct().collect(Collectors.toList());
        HashMap<Long, String> versionMapping = new HashMap<Long, String>();
        ids.forEach(id -> {
            try {
                versionMapping.put(Long.parseLong(id), appVersion);
            }
            catch (Throwable throwable) {
                log.error("{}", (Object)throwable.getMessage());
            }
        });
        return new CurrentVersion(versionMapping);
    }

    @Override
    public AppItem getCurrentApp() {
        Optional stringObjectMap = this.metadataEngine.get(__.has((String)"nodeLabel", (Object)"App"));
        AppItem appItem = new AppItem();
        if (stringObjectMap.isPresent()) {
            String code = ((Map)stringObjectMap.get()).get("code").toString();
            String version = ((Map)stringObjectMap.get()).get("version").toString();
            appItem.setAppCode(code);
            appItem.setAppVersion(version);
        } else {
            appItem.setAppCode("unknown");
            appItem.setAppVersion("unknown");
        }
        return appItem;
    }

    static class UnionKey {
        private String code;
        private Long id;
        private String version;
        private String profile;

        public UnionKey(String code, Long id, String version, String profile) {
            this.code = code;
            this.id = id;
            this.version = version;
            this.profile = profile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnionKey unionKey = (UnionKey)o;
            return Objects.equals(this.code, unionKey.code) && Objects.equals(this.id, unionKey.id) && Objects.equals(this.profile, unionKey.profile) && Objects.equals(this.version, unionKey.version);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.id, this.version, this.profile);
        }

        public String toString() {
            return "UnionKey{code='" + this.code + '\'' + ", id=" + this.id + ", version='" + this.version + '\'' + ", profile='" + this.profile + '\'' + '}';
        }
    }

    class ProfiledEntityClass {
        private String profile;
        private IEntityClass entityClass;

        public ProfiledEntityClass(String profile, IEntityClass entityClass) {
            this.profile = profile;
            this.entityClass = entityClass;
        }

        public String getProfile() {
            return this.profile;
        }

        public IEntityClass getEntityClass() {
            return this.entityClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProfiledEntityClass that = (ProfiledEntityClass)o;
            return Objects.equals(this.profile, that.profile) && Objects.equals(this.entityClass, that.entityClass);
        }

        public int hashCode() {
            return Objects.hash(this.profile, this.entityClass);
        }
    }
}

