/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.engine.impl;

import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.ultraman.metadata.domain.record.GeneralRecord;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.engine.dsl.ResourcePath;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.IRelation;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.ColumnField;
import com.xforceplus.ultraman.sdk.infra.CacheLike;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class EntityClassGroupImpl
implements EntityClassGroup,
Refreshable,
CacheLike {
    private MetadataEngine metadataEngine;
    private EntityClassEngine classEngine;
    private IEntityClass mainEntityClass;
    private Collection<IEntityClass> fatherEntityClasses = null;
    private Collection<IEntityClass> childrenEntityClasses = null;
    private Collection<String> relatedEntityClassCodes = null;
    private String profile;

    public EntityClassGroupImpl(EntityClassEngine classEngine, MetadataEngine metadataEngine, IEntityClass mainEntityClass, String profile) {
        this.classEngine = classEngine;
        this.metadataEngine = metadataEngine;
        this.mainEntityClass = mainEntityClass;
        this.profile = profile;
    }

    @Override
    public Collection<IEntityClass> getFatherEntityClass() {
        if (this.fatherEntityClasses == null) {
            if (null != this.metadataEngine) {
                List listFathers = (List)this.metadataEngine.raw(g -> {
                    GraphTraversal node = g.traversal().V(new Object[0]).has("_id", (Object)Long.toString(this.mainEntityClass.id())).emit().repeat((Traversal)__.out((String[])new String[]{MetadataRelationType.FATHER.name()})).times(5).dedup(new String[0]).not((Traversal)__.has((String)"_id", (Object)Long.toString(this.mainEntityClass.id())));
                    ArrayList list = new ArrayList();
                    while (node.hasNext()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        list.add(map);
                        Vertex next = (Vertex)node.next();
                        Iterator properties = next.properties(new String[0]);
                        while (properties.hasNext()) {
                            VertexProperty next1 = (VertexProperty)properties.next();
                            map.put(next1.key(), next1.value());
                        }
                    }
                    return list;
                });
                this.fatherEntityClasses = listFathers.stream().map(x -> this.classEngine.load(String.valueOf(x.get("_id")), this.profile)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            } else {
                return new ArrayList<IEntityClass>();
            }
        }
        return this.fatherEntityClasses;
    }

    @Override
    public Collection<IEntityClass> getChildrenEntityClass() {
        if (this.childrenEntityClasses == null) {
            if (null != this.metadataEngine) {
                List listFathers = (List)this.metadataEngine.raw(g -> {
                    GraphTraversal node = g.traversal().V(new Object[0]).has("_id", (Object)Long.toString(this.mainEntityClass.id())).emit().repeat((Traversal)__.out((String[])new String[]{MetadataRelationType.SON.name()})).times(5).dedup(new String[0]).not((Traversal)__.has((String)"_id", (Object)Long.toString(this.mainEntityClass.id())));
                    ArrayList list = new ArrayList();
                    while (node.hasNext()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        list.add(map);
                        Vertex next = (Vertex)node.next();
                        Iterator properties = next.properties(new String[0]);
                        while (properties.hasNext()) {
                            VertexProperty next1 = (VertexProperty)properties.next();
                            map.put(next1.key(), next1.value());
                        }
                    }
                    return list;
                });
                this.childrenEntityClasses = listFathers.stream().map(x -> this.classEngine.load(String.valueOf(x.get("_id")), this.profile)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            } else {
                return new ArrayList<IEntityClass>();
            }
        }
        return this.childrenEntityClasses;
    }

    @Override
    public Collection<IRelation> getAllRelations() {
        LinkedList<IRelation> allRelation = new LinkedList<IRelation>(this.mainEntityClass.relations());
        this.getFatherEntityClass().stream().flatMap(x -> x.relations().stream()).forEach(allRelation::add);
        return allRelation;
    }

    @Override
    public Collection<IEntityField> getAllFields() {
        ArrayList<IEntityField> allFields = new ArrayList<IEntityField>(this.mainEntityClass.fields());
        this.getFatherEntityClass().stream().flatMap(x -> x.fields().stream()).forEach(allFields::add);
        return allFields;
    }

    @Override
    public Optional<IEntityField> field(String rawCode) {
        Optional<IEntityField> field = this.mainEntityClass.field(rawCode);
        if (!field.isPresent()) {
            return this.getFatherEntityClass().stream().map(x -> x.field(rawCode)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        return field;
    }

    @Override
    public Optional<IEntityField> field(long fieldId) {
        Optional<IEntityField> field = this.mainEntityClass.field(fieldId);
        if (!field.isPresent()) {
            return this.getFatherEntityClass().stream().map(x -> x.field(fieldId)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        return field;
    }

    @Override
    public Optional<IRelation> relation(long relationId) {
        Optional<IRelation> first = this.mainEntityClass.relations().stream().filter(x -> x.getId() == relationId).findFirst();
        if (!first.isPresent()) {
            return this.getFatherEntityClass().stream().flatMap(x -> x.relations().stream()).filter(x -> x.getId() == relationId).findFirst();
        }
        return first;
    }

    @Override
    public Optional<IRelation> relation(String relationCode) {
        Optional<IRelation> first = this.mainEntityClass.relations().stream().filter(x -> x.getName().equalsIgnoreCase(relationCode)).findFirst();
        if (!first.isPresent()) {
            return this.getFatherEntityClass().stream().flatMap(x -> x.relations().stream()).filter(x -> x.getName().equalsIgnoreCase(relationCode)).findFirst();
        }
        return first;
    }

    @Override
    public Optional<IEntityClass> relatedEntityClass(String relatedCode) {
        Optional<IRelation> first = this.mainEntityClass.relations().stream().filter(x -> x.getRelOwnerClassId() == this.mainEntityClass.id()).filter(x -> x.getName().equals(relatedCode)).findFirst();
        if (first.isPresent()) {
            return this.classEngine.load(String.valueOf(first.get().getEntityClassId()), this.profile);
        }
        Optional<IRelation> relationInParent = this.getFatherEntityClass().stream().map(x -> x.relations().stream().filter(rel -> rel.getRelOwnerClassId() == x.id()).filter(rel -> rel.getName().equals(relatedCode)).findFirst()).filter(Optional::isPresent).map(Optional::get).findFirst();
        return relationInParent.flatMap(x -> this.classEngine.load(String.valueOf(x.getEntityClassId()), this.profile));
    }

    @Override
    public IEntityClass getEntityClass() {
        return this.mainEntityClass;
    }

    @Override
    public String profile() {
        return this.profile;
    }

    @Override
    public String realProfile() {
        String profile = this.mainEntityClass.realProfile();
        if (StringUtils.isEmpty((CharSequence)profile)) {
            Optional<String> first = this.getFatherEntityClass().stream().map(IEntityClass::realProfile).filter(cs -> !StringUtils.isEmpty((CharSequence)cs)).findFirst();
            if (first.isPresent()) {
                return profile;
            }
            return null;
        }
        return profile;
    }

    @Override
    public EntityClassGroup relatedEntityClassWithRawName(String rawName) {
        Optional<IEntityClass> targetEntityClass = this.classEngine.loadByCode(rawName, this.profile);
        if (targetEntityClass.isPresent()) {
            IEntityClass entityClass = targetEntityClass.get();
            return this.classEngine.describe(entityClass, this.profile());
        }
        throw new RuntimeException("EntityClass not found:" + rawName);
    }

    @Override
    public EntityClassEngine classEngine() {
        return this.classEngine;
    }

    @Override
    public Record toRecordNew(Map<Tuple2<String, Long>, Object> body, long entityClassId) {
        Collection<Object> fieldsList = Collections.emptyList();
        if (this.mainEntityClass.id() == entityClassId || entityClassId == 0L) {
            IEntityClass targetClass = this.mainEntityClass;
            fieldsList = this.getAllFields();
        } else {
            Optional<IEntityClass> targetOp = this.fatherEntityClasses.stream().filter(x -> x.id() == entityClassId).findFirst();
            if (targetOp.isPresent()) {
                IEntityClass targetClass = targetOp.get();
                fieldsList = this.classEngine.describe(targetClass, this.profile).getAllFields();
            } else {
                targetOp = this.childrenEntityClasses.stream().filter(x -> x.id() == entityClassId).findFirst();
                if (targetOp.isPresent()) {
                    IEntityClass targetClass = targetOp.get();
                    fieldsList = this.classEngine.describe(targetClass, this.profile).getAllFields();
                }
            }
        }
        ArrayList<IEntityField> finalFieldList = new ArrayList<IEntityField>(fieldsList);
        body.entrySet().stream().map(entry -> {
            String s = (String)((Tuple2)entry.getKey())._1;
            return s;
        }).filter(s -> s.startsWith("_") && s.contains(".")).distinct().forEach(x -> {
            Optional<ColumnField> column = this.column((String)x);
            if (column.isPresent()) {
                finalFieldList.add(column.get());
            }
        });
        GeneralRecord record = new GeneralRecord(finalFieldList, 0);
        record.setTypeId(entityClassId);
        finalFieldList.forEach(x -> {
            record.set((IEntityField)x, body.get(Tuple.of((Object)x.name(), (Object)x.id())));
            if (x.name().equalsIgnoreCase("id")) {
                Optional<Object> o = record.get((IEntityField)x);
                o.ifPresent(id -> record.setId(Long.parseLong(id.toString())));
            }
        });
        return record;
    }

    @Override
    public Optional<ColumnField> column(String fieldCode) {
        Optional<ColumnField> column = this.classEngine.column(this.getEntityClass(), ResourcePath.parse("@".concat(this.mainEntityClass.code()).concat(this.reCalculate(fieldCode))), this.profile);
        column.ifPresent(x -> x.setName(fieldCode));
        return column;
    }

    private String reCalculate(String fieldCode) {
        if (fieldCode.startsWith("_") && fieldCode.contains(".")) {
            int i;
            String[] split = fieldCode.substring(1).split("\\.");
            StringBuilder sb = new StringBuilder();
            boolean lastPartIsMain = false;
            for (i = 0; i < split.length - 1; ++i) {
                if (i == 0) {
                    sb.append("#_").append(split[i]);
                    continue;
                }
                if (i == split.length - 1 && !split[i].startsWith("_")) {
                    lastPartIsMain = true;
                }
                sb.append("#").append(split[i]);
            }
            if (lastPartIsMain) {
                sb.append("#").append(split[i]);
            } else {
                sb.append(".").append(split[i]);
            }
            return sb.toString();
        }
        return "#".concat(fieldCode);
    }

    @Override
    public List<ColumnField> columns(String fieldCode) {
        return this.classEngine.columns(this.getEntityClass(), ResourcePath.parse("@".concat(this.mainEntityClass.code()).concat(this.reCalculate(fieldCode))), this.profile);
    }

    @Override
    public List<ColumnField> columns() {
        Stream<ColumnField> mainFields = this.mainEntityClass.fields().stream().map(x -> new ColumnField(x.name(), (IEntityField)x, this.mainEntityClass));
        Stream fatherFields = this.getFatherEntityClass().stream().flatMap(x -> x.fields().stream().map(field -> new ColumnField(field.name(), (IEntityField)field, (IEntityClass)x)));
        return Stream.concat(mainFields, fatherFields).collect(Collectors.toList());
    }

    @Override
    public String getJoinTable(String tableName) {
        ArrayList<String> finalTableNames = new ArrayList<String>();
        String selfTable = this.getEntityClass().masterWriteTable(false);
        finalTableNames.add(selfTable);
        String profile = this.realProfile();
        if (!StringUtils.isEmpty((CharSequence)profile)) {
            String selfWithProfile = this.getEntityClass().masterWriteTable(true);
            finalTableNames.add(selfWithProfile);
            Collection<IEntityClass> fatherEntityClass = this.getFatherEntityClass();
            fatherEntityClass.forEach(f -> {
                EntityClassGroup describe = this.classEngine.describe((IEntityClass)f, profile);
                String parentRealProfile = describe.realProfile();
                String table = describe.getEntityClass().masterWriteTable(false);
                finalTableNames.add(table);
                if (!StringUtils.isEmpty((CharSequence)parentRealProfile)) {
                    String profiledTable = describe.getEntityClass().masterWriteTable(true);
                    finalTableNames.add(profiledTable);
                }
            });
        } else {
            Collection<IEntityClass> fatherEntityClass = this.getFatherEntityClass();
            fatherEntityClass.forEach(f -> {
                EntityClassGroup describe = this.classEngine.describe((IEntityClass)f, null);
                String table = describe.getEntityClass().masterWriteTable(false);
                finalTableNames.add(table);
            });
        }
        if (finalTableNames.contains(tableName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(tableName);
            finalTableNames.stream().filter(x -> !x.equals(tableName)).forEach(t -> sb.append(" JOIN ").append((String)t).append(" ON ").append(tableName).append(".id = ").append((String)t).append(".id "));
            return sb.toString();
        }
        return tableName;
    }

    public void onRefresh(Object payload) {
        this.refreshCache();
    }

    public void refreshCache() {
        this.fatherEntityClasses = null;
        this.childrenEntityClasses = null;
    }
}

