/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.helper;

import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Conditions;
import com.xforceplus.ultraman.metadata.domain.vo.dto.EntityItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldCondition;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldSort;
import com.xforceplus.ultraman.metadata.domain.vo.dto.NameMapping;
import com.xforceplus.ultraman.metadata.domain.vo.dto.SubEntityItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.SubFieldCondition;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConditionQueryRequestHelper {
    public static void transformer(ConditionQueryRequest condition) {
        if (condition.getConditions() != null) {
            Conditions conditions = condition.getConditions();
            Optional.ofNullable(conditions.getFields()).orElseGet(Collections::emptyList).forEach(ConditionQueryRequestHelper::transformer);
            Optional.ofNullable(conditions.getEntities()).orElseGet(Collections::emptyList).stream().flatMap(x -> Optional.ofNullable(x.getFields()).orElseGet(Collections::emptyList).stream()).forEach(ConditionQueryRequestHelper::transformer);
        }
    }

    private static void transformer(FieldCondition fieldCondition) {
        ConditionOp operation = fieldCondition.getOperation();
        List<String> values = fieldCondition.getValue();
        switch (operation) {
            case ge_le: {
                ConditionQueryRequestHelper.fallBack(fieldCondition, values, ConditionOp.ge, ConditionOp.le);
                break;
            }
            case ge_lt: {
                ConditionQueryRequestHelper.fallBack(fieldCondition, values, ConditionOp.ge, ConditionOp.lt);
                break;
            }
            case gt_le: {
                ConditionQueryRequestHelper.fallBack(fieldCondition, values, ConditionOp.gt, ConditionOp.le);
                break;
            }
            case gt_lt: {
                ConditionQueryRequestHelper.fallBack(fieldCondition, values, ConditionOp.gt, ConditionOp.lt);
                break;
            }
        }
    }

    private static void fallBack(FieldCondition fieldCondition, List<String> values, ConditionOp first, ConditionOp second) {
        if (values.size() >= 2) {
            if (values.get(0) == null) {
                fieldCondition.setOperation(second);
                fieldCondition.setValue(Arrays.asList(values.get(1)));
            } else if (values.get(1) == null) {
                fieldCondition.setOperation(first);
                fieldCondition.setValue(Arrays.asList(values.get(0)));
            }
        }
    }

    public static ConditionQueryRequest build(List<Long> ids, ConditionQueryRequest condition) {
        if (ids == null) {
            return condition;
        }
        ConditionQueryRequest newRequest = ConditionQueryRequestHelper.copyOrNew(condition);
        Conditions conditions = newRequest.getConditions();
        FieldCondition idCondition = new FieldCondition();
        idCondition.setCode("id");
        idCondition.setOperation(ConditionOp.in);
        idCondition.setValue(ids.stream().map(Object::toString).collect(Collectors.toList()));
        if (conditions == null) {
            List<FieldCondition> fieldConditions = Collections.singletonList(idCondition);
            Conditions newConditions = new Conditions();
            newConditions.setFields(fieldConditions);
            newRequest.setConditions(newConditions);
        } else {
            List<FieldCondition> fields = conditions.getFields();
            List fieldConditions = Optional.ofNullable(fields).map(LinkedList::new).orElseGet(LinkedList::new);
            fieldConditions.add(idCondition);
            conditions.setFields(fieldConditions);
        }
        return newRequest;
    }

    public static ConditionQueryRequest copyOrNew(ConditionQueryRequest condition) {
        EntityItem entity;
        List<FieldSort> sort;
        List<NameMapping> mapping;
        ConditionQueryRequest result = new ConditionQueryRequest();
        if (condition == null) {
            return result;
        }
        Conditions conditions = condition.getConditions();
        if (conditions != null) {
            Conditions newConditions = new Conditions();
            if (conditions.getFields() != null) {
                newConditions.setFields(new LinkedList<FieldCondition>(conditions.getFields()));
            }
            if (conditions.getEntities() != null) {
                newConditions.setEntities(new LinkedList<SubFieldCondition>(conditions.getEntities()));
            }
            result.setConditions(newConditions);
        }
        if ((mapping = condition.getMapping()) != null) {
            result.setMapping(new LinkedList<NameMapping>(mapping));
        }
        if ((sort = condition.getSort()) != null) {
            result.setSort(new LinkedList<FieldSort>(sort));
        }
        if ((entity = condition.getEntity()) != null) {
            EntityItem newItem = new EntityItem();
            List<SubEntityItem> entities = entity.getEntities();
            List<String> fields = entity.getFields();
            if (entities != null) {
                newItem.setEntities(new LinkedList<SubEntityItem>(entities));
            }
            if (fields != null) {
                newItem.setFields(new LinkedList<String>(fields));
            }
            result.setEntity(newItem);
        }
        result.setPageSize(condition.getPageSize());
        result.setPageNo(condition.getPageNo());
        return result;
    }

    public static void removeUselessField(EntityClassEngine engine, EntityClassGroup group, String profile, ConditionQueryRequest conditionQueryRequest) {
        Collection<IEntityField> allFields = group.getAllFields();
        Set validString = allFields.stream().map(IEntityField::name).collect(Collectors.toSet());
        EntityItem entity = conditionQueryRequest.getEntity();
        if (entity != null) {
            List<String> validCodes = Optional.ofNullable(entity.getFields()).orElseGet(Collections::emptyList).stream().filter(validString::contains).collect(Collectors.toList());
            entity.setFields(validCodes);
            if (entity.getEntities() != null && !entity.getEntities().isEmpty()) {
                entity.getEntities().stream().forEach(x -> {
                    String relationCode = x.getCode();
                    List<String> requestRelatedCodes = x.getFields();
                    Optional<IEntityClass> relatedEntityClassOp = group.relatedEntityClass(relationCode);
                    if (relatedEntityClassOp.isPresent()) {
                        IEntityClass entityClass = relatedEntityClassOp.get();
                        EntityClassGroup relatedGroup = engine.describe(entityClass, profile);
                        List relatedValidCodes = relatedGroup.getAllFields().stream().map(IEntityField::name).collect(Collectors.toList());
                        List<String> filteredRelatedCodes = requestRelatedCodes.stream().filter(relatedValidCodes::contains).collect(Collectors.toList());
                        x.setFields(filteredRelatedCodes);
                    }
                });
            }
        }
        Conditions conditions = conditionQueryRequest.getConditions();
        List<FieldCondition> fields = conditions.getFields();
        List<FieldCondition> filtered = fields.stream().filter(x -> validString.contains(x.getCode())).collect(Collectors.toList());
        conditions.setFields(filtered);
        List entities = Optional.ofNullable(conditions.getEntities()).orElseGet(Collections::emptyList);
        entities.forEach(x -> {
            String code = x.getCode();
            List<FieldCondition> subFields = x.getFields();
            Optional<IEntityClass> relatedEntityClassOp = group.relatedEntityClass(code);
            if (relatedEntityClassOp.isPresent()) {
                IEntityClass entityClass = relatedEntityClassOp.get();
                EntityClassGroup relatedGroup = engine.describe(entityClass, profile);
                List relatedValidCodes = relatedGroup.getAllFields().stream().map(IEntityField::name).collect(Collectors.toList());
                List<FieldCondition> filteredRelatedCodes = subFields.stream().filter(subFieldCode -> relatedValidCodes.contains(subFieldCode)).collect(Collectors.toList());
                x.setFields(filteredRelatedCodes);
            }
        });
    }
}

