/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.EntityClassRef;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.sdk.infra.utils.JacksonDefaultMapper;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginEntityUtils {
    private static final Logger logger = LoggerFactory.getLogger(OriginEntityUtils.class);

    public static OqsEngineEntity generateFromResultSet(ResultSet resultSet, IEntityClass tableEntityClass, EntityClassEngine engine) throws SQLException, JsonProcessingException {
        long entityClassId = resultSet.getLong("_sys_entityclass");
        String profile = resultSet.getString("_sys_profile");
        IEntityClass relationTableEntityClass = engine.load(String.valueOf(entityClassId), profile).orElse(null);
        List<String> tableEntityClasses = Collections.emptyList();
        if (null != relationTableEntityClass) {
            tableEntityClasses = new ArrayList<String>(relationTableEntityClass.getEntityTables());
        }
        OqsEngineEntity.Builder builder = new OqsEngineEntity.Builder();
        builder.withEntityClassRef(new EntityClassRef(entityClassId, "", "", profile));
        builder.withRelationTables(tableEntityClass.id(), tableEntityClass.code());
        builder.withTableEntityClass(tableEntityClasses);
        if (entityClassId != tableEntityClass.id()) {
            builder.withFather(tableEntityClass.id());
        } else {
            IEntityClass ec = tableEntityClass.extendEntityClass();
            if (null != ec) {
                builder.withFather(ec.id());
            } else {
                builder.withFather(0L);
            }
        }
        HashMap iEntityFieldMap = new HashMap();
        engine.describe(tableEntityClass, profile).getAllFields().forEach(p -> iEntityFieldMap.put(p.name().replace(".", "_"), p));
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int rowCount = resultSetMetaData.getColumnCount();
        for (int index = 1; index <= rowCount; ++index) {
            String columnName = resultSetMetaData.getColumnName(index);
            try {
                if (columnName.equals("id")) {
                    long id = resultSet.getLong("id");
                    builder.withId(id);
                    builder.withAttribute("id", id);
                }
                if (columnName.equals("_sys_operatetime")) {
                    long updateTime = resultSet.getLong(index);
                    builder.withUpdateTime(updateTime);
                    continue;
                }
                if (columnName.equals("_sys_ver")) {
                    builder.withVersion(resultSet.getInt(index));
                    continue;
                }
                if (columnName.equals("_sys_deleted")) {
                    builder.withDeleted(resultSet.getLong("_sys_deleted") != 0L);
                    continue;
                }
                if (columnName.equals("_sys_entityclass") || columnName.equals("_sys_profile")) continue;
                if (columnName.equals("_sys_dynamic")) {
                    builder.withAttributes(OriginEntityUtils.parserDynamic(tableEntityClass, resultSet.getString("_sys_dynamic"), !StringUtils.isEmpty((String)tableEntityClass.realProfile())));
                    continue;
                }
                IEntityField field = (IEntityField)iEntityFieldMap.get(columnName);
                if (null == field) {
                    logger.warn("entityField can not be null, column name {}", (Object)columnName);
                    continue;
                }
                OriginEntityUtils.formatFiledValues(builder, field, columnName, resultSet, index);
                continue;
            }
            catch (Exception e) {
                logger.warn("column : {} parse failed, cause {}", (Object)columnName, (Object)e.getMessage());
                throw e;
            }
        }
        OqsEngineEntity engineEntity = builder.build();
        engineEntity.updateIntact();
        return engineEntity;
    }

    public static void formatFiledValues(OqsEngineEntity.Builder builder, IEntityField field, String name, ResultSet resultSet, int index) throws SQLException {
        Object r = resultSet.getObject(index);
        switch (field.type()) {
            case LONG: 
            case DATETIME: {
                builder.withAttribute(name, null != r ? Long.valueOf(resultSet.getLong(index)) : null);
                break;
            }
            case BOOLEAN: {
                builder.withAttribute(name, null != r ? Boolean.valueOf(resultSet.getLong(index) != 0L) : null);
                break;
            }
            case DECIMAL: {
                builder.withAttribute(name, null != r ? resultSet.getBigDecimal(index) : null);
                break;
            }
            case STRING: {
                builder.withAttribute(name, null != r ? resultSet.getString(index) : null);
                break;
            }
            case STRINGS: {
                try {
                    List multiValues = null;
                    if (null != r) {
                        multiValues = (List)JacksonDefaultMapper.OBJECT_MAPPER.readValue(resultSet.getString(index), JacksonDefaultMapper.LIST_TYPE_REFERENCE);
                    }
                    builder.withAttribute(name, multiValues);
                }
                catch (Throwable throwable) {
                    try {
                        Object o = resultSet.getObject(index);
                        builder.withAttribute(name, o);
                    }
                    catch (Throwable throwable2) {}
                }
                break;
            }
            default: {
                builder.withAttribute(name, resultSet.getObject(index));
            }
        }
    }

    public static void formatFiledValues(OqsEngineEntity.Builder builder, IEntityField field, String name, String value) {
        switch (field.type()) {
            case LONG: 
            case DATETIME: {
                builder.withAttribute(name, Long.parseLong(value));
                break;
            }
            case BOOLEAN: {
                long result = Long.parseLong(value);
                builder.withAttribute(name, result != 0L);
                break;
            }
            case DECIMAL: {
                builder.withAttribute(name, new BigDecimal(value));
                break;
            }
            case STRINGS: 
            case ENUMS: {
                try {
                    List multiValues = (List)JacksonDefaultMapper.OBJECT_MAPPER.readValue(value, JacksonDefaultMapper.LIST_TYPE_REFERENCE);
                    builder.withAttribute(name, multiValues);
                }
                catch (Throwable throwable) {
                    builder.withAttribute(name, value);
                }
                break;
            }
            default: {
                builder.withAttribute(name, value);
            }
        }
    }

    public static Map<String, Object> parserDynamic(IEntityClass entityClass, String attrStr, boolean isProfiled) throws JsonProcessingException {
        Map<Object, Object> result = null == attrStr || attrStr.isEmpty() ? new HashMap() : OriginEntityUtils.attributesToMap(attrStr);
        Collection targetFields = isProfiled ? (Collection)entityClass.selfFields().stream().filter(x -> !StringUtils.isEmpty((String)x.realProfile())).collect(Collectors.toList()) : entityClass.selfFields();
        targetFields.stream().filter(IEntityField::isDynamic).forEach(f -> {
            if (!result.containsKey(f.name())) {
                result.put(f.name(), null);
            } else if (f.type().equals((Object)FieldType.BOOLEAN)) {
                result.computeIfPresent(f.name(), (k, s) -> (Integer)s != 0);
            }
        });
        return result;
    }

    public static Map<String, Object> attributesToMap(String attrStr) throws JsonProcessingException {
        return (Map)JacksonDefaultMapper.OBJECT_MAPPER.readValue(attrStr, Map.class);
    }
}

