/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.helper.converter;

import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.EntityField;
import com.xforceplus.ultraman.metadata.values.DateTimeValue;
import com.xforceplus.ultraman.metadata.values.IValue;
import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.commons.beanutils.converters.AbstractConverter;

public class LocalDateTimeConverter
extends AbstractConverter {
    IEntityField dummy = new EntityField(1L, "", FieldType.DATETIME);

    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        Optional<IValue> iValue;
        Class<?> sourceType = value.getClass();
        if (value instanceof LocalDateTime) {
            return (T)value;
        }
        String valStr = value.toString();
        if (FieldType.DATETIME.canParseFrom(valStr).booleanValue() && (iValue = FieldType.DATETIME.toTypedValue(this.dummy, valStr)).isPresent()) {
            return (T)((DateTimeValue)iValue.get()).getValue();
        }
        return null;
    }

    protected Class<?> getDefaultType() {
        return LocalDateTime.class;
    }

    protected String convertToString(Object value) throws Throwable {
        if (value instanceof LocalDateTime) {
            return Long.toString(new DateTimeValue(null, (LocalDateTime)value).valueToLong());
        }
        return super.convertToString(value);
    }

    public <T> T convert(Class<T> type, Object value) {
        return (T)super.convert(type, value);
    }
}

