/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.values;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class Attachment {
    private Map<String, String> map = new HashMap<String, String>();
    private final IEntityField entityField;

    public Attachment(IEntityField entityField) {
        this.entityField = entityField;
        if (entityField != null) {
            this.map.put("id", String.valueOf(entityField.id()));
        }
    }

    private void setMap(Map<String, String> map) {
        this.map = map;
    }

    public void add(String attachKey, String attachValue) {
        if (attachKey == null || attachValue == null) {
            return;
        }
        this.map.put(attachKey, attachValue);
    }

    public Optional<String> getAttachmentValue(String attachKey) {
        return Optional.ofNullable(this.map.get(attachKey));
    }

    public boolean haveCustomizeValue() {
        for (String key : this.map.keySet()) {
            if ("id".equals(key)) continue;
            return true;
        }
        return false;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    public String toAttachmentString() {
        return this.doAttachmentKeyValueStrings(true).stream().collect(Collectors.joining());
    }

    public List<String> toAttachmentKeyValueStrings() {
        return this.doAttachmentKeyValueStrings(false);
    }

    private List<String> doAttachmentKeyValueStrings(boolean close) {
        ArrayList<String> values = new ArrayList<String>(this.map.size());
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            values.add(this.buildAttachmentString(key, value, close));
        }
        return values;
    }

    private String buildAttachmentString(String key, String value, boolean close) {
        if (close) {
            return String.format("%s%s%s%s%s", Character.valueOf('['), key, Character.valueOf('_'), value, Character.valueOf(']'));
        }
        return String.format("%s%s%s", key, Character.valueOf('_'), value);
    }

    public static Attachment fromAttachmentString(String attachmentString, IEntityField entityField) {
        boolean valueArea = false;
        StringBuilder buff = new StringBuilder();
        Attachment attachment = new Attachment(entityField);
        for (char point : attachmentString.toCharArray()) {
            if ('[' == point) {
                valueArea = true;
                buff.delete(0, buff.length());
                continue;
            }
            if (']' == point) {
                valueArea = false;
                String[] kv = buff.toString().split(Character.toString('_'));
                if (kv.length != 2) {
                    throw new RuntimeException(String.format("Attachment element: %s can not split to attachmentKey and attachmentValue.", buff));
                }
                if (kv[0].equals("id")) continue;
                attachment.add(kv[0], kv[1]);
                continue;
            }
            if (!valueArea) continue;
            buff.append(point);
        }
        return attachment;
    }

    public Attachment copy() {
        Attachment attachment = new Attachment(this.entityField);
        HashMap<String, String> map = new HashMap<String, String>(this.map);
        attachment.setMap(map);
        return attachment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment that = (Attachment)o;
        return this.toAttachmentString().equals(that.toAttachmentString());
    }

    public int hashCode() {
        String value = this.toAttachmentString();
        if (value == null) {
            return 0;
        }
        return Objects.hash(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Attachment{");
        sb.append("entityField=").append(this.entityField);
        sb.append(", map=").append(this.map);
        sb.append('}');
        return sb.toString();
    }
}

